/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.base.clips;

public abstract class EffectClip {
    private final int startTime;
    private final int duration;

    protected EffectClip(int startTime, int duration) {
        this.startTime = startTime;
        this.duration = duration;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean isActive(int timelineAge) {
        return timelineAge >= this.startTime && timelineAge <= this.startTime + this.duration;
    }

    public float getProgress(int timelineAge) {
        if (timelineAge < this.startTime) {
            return 0.0f;
        }
        if (timelineAge > this.startTime + this.duration) {
            return 1.0f;
        }
        if (this.duration == 0) {
            return 1.0f;
        }
        return (float)(timelineAge - this.startTime) / (float)this.duration;
    }
}

