/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.handler;

import com.radar.biohazardchanges.client.vfx.base.EffectTrack;
import com.radar.biohazardchanges.client.vfx.base.clips.EffectClip;
import com.radar.biohazardchanges.client.vfx.base.clips.ParticleClip;
import com.radar.biohazardchanges.client.vfx.base.clips.PositionClip;
import com.radar.biohazardchanges.client.vfx.handler.IEffectTrackHandler;
import com.radar.biohazardchanges.client.vfx.playback.TimelineInstance;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.options.LodestoneTerrainParticleOptions;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class ParticleTrackHandler
implements IEffectTrackHandler {
    @Override
    public void handle(TimelineInstance instance, EffectTrack track) {
        for (EffectClip clipUntyped : track.getClips()) {
            ParticleClip clip;
            if (!(clipUntyped instanceof ParticleClip) || !(clip = (ParticleClip)clipUntyped).isActive(instance.getAge()) || instance.getAge() % clip.frequency != 0) continue;
            Vec3 basePos = instance.getPosition();
            if (clip.localPositionTrack != null) {
                Vec3 localOffset = Vec3.f_82478_;
                int localAge = instance.getAge() - clip.getStartTime();
                for (EffectClip posClipUntyped : clip.localPositionTrack.getClips()) {
                    PositionClip posClip;
                    if (!(posClipUntyped instanceof PositionClip) || (posClip = (PositionClip)posClipUntyped).getStartTime() > localAge || localAge >= posClip.getStartTime() + posClip.getDuration()) continue;
                    float elapsedTime = localAge - posClip.getStartTime();
                    float duration = posClip.getDuration();
                    double x = posClip.easing.ease((double)elapsedTime, posClip.fromPos.f_82479_, posClip.toPos.f_82479_ - posClip.fromPos.f_82479_, (double)duration);
                    double y = posClip.easing.ease((double)elapsedTime, posClip.fromPos.f_82480_, posClip.toPos.f_82480_ - posClip.fromPos.f_82480_, (double)duration);
                    double z = posClip.easing.ease((double)elapsedTime, posClip.fromPos.f_82481_, posClip.toPos.f_82481_ - posClip.fromPos.f_82481_, (double)duration);
                    localOffset = localOffset.m_82549_(new Vec3(x, y, z));
                }
                basePos = basePos.m_82549_(localOffset);
            }
            Collection<Vec3> spawnPositions = clip.spawnPattern != null ? clip.spawnPattern.getPositions(instance) : Collections.singletonList(Vec3.f_82478_);
            for (Vec3 offset : spawnPositions) {
                Vec3 spawnPos = basePos.m_82549_(offset);
                this.spawnParticle(instance, clip, spawnPos);
            }
        }
    }

    private void spawnParticle(TimelineInstance instance, ParticleClip clip, Vec3 spawnPos) {
        ParticleOptions options = clip.supplier.get(instance.getLevel(), instance.getLevel().f_46441_, BlockPos.m_274446_((Position)spawnPos));
        if (options == null) {
            return;
        }
        if (options instanceof LodestoneTerrainParticleOptions) {
            LodestoneTerrainParticleOptions terrainOptions = (LodestoneTerrainParticleOptions)options;
            WorldParticleBuilder builder = WorldParticleBuilder.create((WorldParticleOptions)terrainOptions).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.TERRAIN_SHEET);
            if (clip.script != null) {
                clip.script.apply(instance, builder);
            }
            builder.spawn(instance.getLevel(), spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        } else if (options instanceof WorldParticleOptions) {
            WorldParticleOptions worldOptions = (WorldParticleOptions)options;
            WorldParticleBuilder builder = WorldParticleBuilder.create((WorldParticleOptions)worldOptions);
            if (clip.script != null) {
                clip.script.apply(instance, builder);
            }
            builder.spawn(instance.getLevel(), spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        } else {
            instance.getLevel().m_7106_(options, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

