/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.particles.patterns;

import com.radar.biohazardchanges.client.vfx.particles.patterns.ISpawnPattern;
import com.radar.biohazardchanges.client.vfx.playback.TimelineInstance;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.phys.Vec3;

public class LinePattern
implements ISpawnPattern {
    private final int particleCount;
    private final float length;

    public LinePattern(int particleCount, float length) {
        this.particleCount = particleCount;
        this.length = length;
    }

    @Override
    public Collection<Vec3> getPositions(TimelineInstance instance) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        float start = -this.length / 2.0f;
        if (this.particleCount <= 1) {
            positions.add(new Vec3((double)start, 0.0, 0.0));
            return positions;
        }
        float step = this.length / (float)(this.particleCount - 1);
        for (int i = 0; i < this.particleCount; ++i) {
            positions.add(new Vec3((double)(start + (float)i * step), 0.0, 0.0));
        }
        return positions;
    }
}

