/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.client.vfx.playback;

import com.radar.biohazardchanges.client.vfx.VFXTimelineRegistry;
import com.radar.biohazardchanges.client.vfx.base.EffectTimeline;
import com.radar.biohazardchanges.client.vfx.playback.TimelineInstance;
import com.radar.biohazardchanges.common.network.NetworkHandler;
import com.radar.biohazardchanges.common.network.PlayVFXPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="biohazardchanges", value={Dist.CLIENT})
public class VFXSystem {
    private static final List<TimelineInstance> activeInstances = new ArrayList<TimelineInstance>();
    private static final List<TimelineInstance> pendingInstances = new ArrayList<TimelineInstance>();

    public static UUID play(ResourceLocation timelineId, Level level, Vec3 position) {
        EffectTimeline timeline = VFXTimelineRegistry.get(timelineId);
        if (timeline != null) {
            return VFXSystem.play(timeline, level, position);
        }
        return null;
    }

    public static UUID play(EffectTimeline timeline, Level level, Vec3 position) {
        if (level.f_46443_) {
            TimelineInstance instance = new TimelineInstance(timeline, level, position);
            pendingInstances.add(instance);
            return instance.getId();
        }
        NetworkHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(position.f_82479_, position.f_82480_, position.f_82481_, 64.0, level.m_46472_())), (Object)new PlayVFXPacket(timeline.getId(), position));
        return null;
    }

    public static List<TimelineInstance> getInstancesAt(Vec3 position) {
        return activeInstances.stream().filter(i -> i.getPosition().equals((Object)position)).collect(Collectors.toList());
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            activeInstances.removeIf(instance -> {
                instance.tick();
                return instance.isFinished();
            });
            if (!pendingInstances.isEmpty()) {
                activeInstances.addAll(pendingInstances);
                pendingInstances.clear();
            }
        }
    }
}

