/*
 * Decompiled with CFR 0.152.
 */
package com.radar.biohazardchanges.common.events;

import com.radar.biohazardchanges.common.events.IServerEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ServerEventRegistry {
    private static final Map<ResourceLocation, IServerEvent> REGISTRY = new HashMap<ResourceLocation, IServerEvent>();

    public static void register(ResourceLocation id, IServerEvent event) {
        if (REGISTRY.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate server event ID: " + id);
        }
        REGISTRY.put(id, event);
    }

    @Nullable
    public static IServerEvent get(ResourceLocation id) {
        return REGISTRY.get(id);
    }

    public static void registerEvents() {
        ServerEventRegistry.register(new ResourceLocation("biohazardchanges", "spawn_firework"), (player, position, extraData) -> {
            ListTag offsetList;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42688_);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag fireworksNbt = new CompoundTag();
            byte flight = 1;
            if (extraData != null && extraData.m_128425_("Flight", 1)) {
                flight = extraData.m_128445_("Flight");
            }
            fireworksNbt.m_128344_("Flight", flight);
            ListTag explosionsNbt = new ListTag();
            if (extraData != null && extraData.m_128425_("Explosions", 9)) {
                explosionsNbt = extraData.m_128437_("Explosions", 10);
            } else if (extraData != null) {
                CompoundTag explosionNbt = new CompoundTag();
                byte shape = 0;
                if (extraData.m_128425_("Shape", 8)) {
                    shape = (byte)(switch (extraData.m_128461_("Shape")) {
                        case "large_ball" -> 1;
                        case "star" -> 2;
                        case "creeper" -> 3;
                        case "burst" -> 4;
                        default -> 0;
                    });
                }
                explosionNbt.m_128344_("Type", shape);
                if (extraData.m_128425_("Colors", 11)) {
                    explosionNbt.m_128385_("Colors", extraData.m_128465_("Colors"));
                }
                if (extraData.m_128425_("FadeColors", 11)) {
                    explosionNbt.m_128385_("FadeColors", extraData.m_128465_("FadeColors"));
                }
                if (extraData.m_128425_("HasTrail", 1)) {
                    explosionNbt.m_128379_("Trail", extraData.m_128471_("HasTrail"));
                }
                if (extraData.m_128425_("HasTwinkle", 1)) {
                    explosionNbt.m_128379_("Flicker", extraData.m_128471_("HasTwinkle"));
                }
                explosionsNbt.add((Object)explosionNbt);
            }
            fireworksNbt.m_128365_("Explosions", (Tag)explosionsNbt);
            nbt.m_128365_("Fireworks", (Tag)fireworksNbt);
            Vec3 finalPos = position;
            if (extraData != null && extraData.m_128425_("Offset", 9) && (offsetList = extraData.m_128437_("Offset", 6)).size() == 3) {
                double x = offsetList.m_128772_(0);
                double y = offsetList.m_128772_(1);
                double z = offsetList.m_128772_(2);
                finalPos = finalPos.m_82520_(x, y, z);
            }
            player.m_9236_().m_7967_((Entity)new FireworkRocketEntity(player.m_9236_(), finalPos.m_7096_(), finalPos.m_7098_(), finalPos.m_7094_(), stack));
        });
    }
}

