/*
 * Decompiled with CFR 0.152.
 */
package com.github.anopensaucedev.fasterrandom.util.math.random;

import com.github.anopensaucedev.fasterrandom.util.math.random.RandomGeneratorFactoryUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.random.RandomGenerator;
import java.util.random.RandomGeneratorFactory;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.jetbrains.annotations.NotNull;

public class RandomGeneratorRandom
implements BitRandomSource {
    @NotNull
    private static final RandomGeneratorFactory<RandomGenerator.SplittableGenerator> RANDOM_GENERATOR_FACTORY = RandomGeneratorFactoryUtil.getRandomGeneratorFactory();
    private static final int INT_BITS = 48;
    private static final long SEED_MASK = 0xFFFFFFFFFFFFL;
    private static final long MULTIPLIER = 25214903917L;
    private static final long INCREMENT = 11L;
    private long seed;
    private RandomGenerator.SplittableGenerator randomGenerator;

    public RandomGeneratorRandom(long seed) {
        this.seed = seed;
        this.randomGenerator = RANDOM_GENERATOR_FACTORY.create(seed);
    }

    public RandomSource m_213769_() {
        return new RandomGeneratorRandom(this.m_188505_());
    }

    public PositionalRandomFactory m_188582_() {
        return new Splitter(this.m_188505_());
    }

    public void m_188584_(long seed) {
        this.seed = seed;
        this.randomGenerator = RANDOM_GENERATOR_FACTORY.create(seed);
    }

    public int m_64707_(int bits) {
        return (int)((this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) >>> 48 - bits);
    }

    public int m_188502_() {
        return this.randomGenerator.nextInt();
    }

    public int m_188503_(int bound) {
        return this.randomGenerator.nextInt(bound);
    }

    public long m_188505_() {
        return this.randomGenerator.nextLong();
    }

    public boolean m_188499_() {
        return this.randomGenerator.nextBoolean();
    }

    public float m_188501_() {
        return this.randomGenerator.nextFloat();
    }

    public double m_188500_() {
        return this.randomGenerator.nextDouble();
    }

    public double m_188583_() {
        return this.randomGenerator.nextGaussian();
    }

    private record Splitter(long seed) implements PositionalRandomFactory
    {
        @NotNull
        public RandomSource m_213715_(int x, int y, int z) {
            return new RandomGeneratorRandom(Mth.m_14130_((int)x, (int)y, (int)z) ^ this.seed);
        }

        @NotNull
        public RandomSource m_214111_(@NotNull String seed) {
            return new RandomGeneratorRandom((long)seed.hashCode() ^ this.seed);
        }

        @VisibleForTesting
        public void m_183502_(@NotNull StringBuilder info) {
            info.append("RandomGeneratorRandom$Splitter{").append(this.seed).append("}");
        }
    }
}

