import os

# Stolen but not forgotten o7
def generate_file_tree(start_path, output_file):
    script_name = os.path.basename(__file__)

    with open(output_file, "w", encoding="utf-8") as f:
        for root, dirs, files in os.walk(start_path):
            # Exclude __pycache__ directories
            dirs[:] = [d for d in dirs if d != "__pycache__"]
            
            level = root.replace(start_path, '').count(os.sep)
            indent = ' ' * 4 * level
            f.write(f'{indent}{os.path.basename(root)}/\n')
            
            sub_indent = ' ' * 4 * (level + 1)
            for file in files:
                # Check if the file is not a .py file
                if not file.endswith('.py'):
                    f.write(f'{sub_indent}{file}\n')

if __name__ == "__main__":
    # Windows: r"C:\Users\YourUser\Documents"
    # macOS/Linux: "/home/youruser/documents"
    # configured to local directory for now, can adjust to string...
    directory_to_scan = os.path.dirname(os.path.abspath(__file__))

    # name
    output_filename = "file_tree.txt"
    # --- End of Configuration ---
    
    start_directory = os.path.abspath(directory_to_scan)
    output_filepath = os.path.join(os.path.dirname(__file__), output_filename)

    try:
        print(f"Scanning directory: {start_directory}")
        generate_file_tree(start_directory, output_filepath)
        print(f"File tree has been saved to: {output_filepath}")
    except FileNotFoundError:
        print(f"Error: The directory '{start_directory}' does not exist.")
    except Exception as e:
        print(f"An unexpected error occurred: {e}")