/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree;

import com.davidmoten.guavamini.Lists;
import com.davidmoten.guavamini.Preconditions;
import com.davidmoten.rtree.Context;
import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.Factory;
import com.davidmoten.rtree.Iterables;
import com.davidmoten.rtree.Leaf;
import com.davidmoten.rtree.Node;
import com.davidmoten.rtree.NonLeaf;
import com.davidmoten.rtree.Search;
import com.davidmoten.rtree.Selector;
import com.davidmoten.rtree.SelectorMinimalVolumeIncrease;
import com.davidmoten.rtree.SelectorRStar;
import com.davidmoten.rtree.Splitter;
import com.davidmoten.rtree.SplitterQuadratic;
import com.davidmoten.rtree.SplitterRStar;
import com.davidmoten.rtree.Visitor;
import com.davidmoten.rtree.Visualizer;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.HasGeometry;
import com.davidmoten.rtree.geometry.Point;
import com.davidmoten.rtree.geometry.Rectangle;
import com.davidmoten.rtree.internal.Comparators;
import com.davidmoten.rtree.internal.NodeAndEntries;
import com.davidmoten.rtree.internal.util.BoundedPriorityQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class RTree<T, S extends Geometry> {
    private final Optional<? extends Node<T, S>> root;
    private final Context<T, S> context;
    public static final int MAX_CHILDREN_DEFAULT_GUTTMAN = 4;
    public static final int MAX_CHILDREN_DEFAULT_STAR = 4;
    private final int size;
    private static final Predicate<Geometry> ALWAYS_TRUE = new Predicate<Geometry>(){

        @Override
        public boolean test(Geometry rectangle) {
            return true;
        }
    };
    private static final String marginIncrement = "  ";

    public RTree(Optional<? extends Node<T, S>> root, int size, Context<T, S> context) {
        this.root = root;
        this.size = size;
        this.context = context;
    }

    private RTree(Node<T, S> root, int size, Context<T, S> context) {
        this(Optional.of(root), size, context);
    }

    public static <T, S extends Geometry> RTree<T, S> create() {
        return new Builder().create();
    }

    public static <T, S extends Geometry> RTree<T, S> create(int dimensions) {
        return new Builder().dimensions(dimensions).create();
    }

    public static Builder dimensions(int dimensions) {
        return new Builder().dimensions(dimensions);
    }

    public int calculateDepth() {
        return RTree.calculateDepth(this.root);
    }

    private static <T, S extends Geometry> int calculateDepth(Optional<? extends Node<T, S>> root) {
        if (!root.isPresent()) {
            return 0;
        }
        return RTree.calculateDepth(root.get(), 0);
    }

    private static <T, S extends Geometry> int calculateDepth(Node<T, S> node, int depth) {
        if (node.isLeaf()) {
            return depth + 1;
        }
        return RTree.calculateDepth(((NonLeaf)node).child(0), depth + 1);
    }

    public static Builder minChildren(int minChildren) {
        return new Builder().minChildren(minChildren);
    }

    public static Builder maxChildren(int maxChildren) {
        return new Builder().maxChildren(maxChildren);
    }

    public static Builder splitter(Splitter splitter) {
        return new Builder().splitter(splitter);
    }

    public static Builder selector(Selector selector) {
        return new Builder().selector(selector);
    }

    public static Builder star() {
        return new Builder().star();
    }

    public RTree<T, S> add(Entry<? extends T, ? extends S> entry) {
        Preconditions.checkArgument(this.dimensions() == entry.geometry().dimensions(), String.valueOf(entry) + " has wrong number of dimensions, expected " + this.dimensions());
        if (this.root.isPresent()) {
            List<Node<T, S>> nodes = this.root.get().add(entry);
            Node<? extends T, ? extends S> node = nodes.size() == 1 ? nodes.get(0) : this.context.factory().createNonLeaf(nodes, this.context);
            return new RTree<T, S>(node, this.size + 1, this.context);
        }
        Leaf node = this.context.factory().createLeaf(Lists.newArrayList(entry), this.context);
        return new RTree(node, this.size + 1, this.context);
    }

    public RTree<T, S> add(T value, S geometry) {
        return this.add(this.context.factory().createEntry(value, geometry));
    }

    public RTree<T, S> add(Iterable<Entry<T, S>> entries) {
        RTree<T, S> tree = this;
        for (Entry<T, S> entry : entries) {
            tree = tree.add(entry);
        }
        return tree;
    }

    public RTree<T, S> delete(Iterable<Entry<T, S>> entries, boolean all) {
        RTree<T, S> tree = this;
        for (Entry<T, S> entry : entries) {
            tree = tree.delete(entry, all);
        }
        return tree;
    }

    public RTree<T, S> delete(Iterable<Entry<T, S>> entries) {
        RTree<T, S> tree = this;
        for (Entry<T, S> entry : entries) {
            tree = tree.delete(entry);
        }
        return tree;
    }

    public RTree<T, S> delete(T value, S geometry, boolean all) {
        return this.delete(this.context.factory().createEntry(value, geometry), all);
    }

    public RTree<T, S> delete(T value, S geometry) {
        return this.delete(this.context.factory().createEntry(value, geometry), false);
    }

    public RTree<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        if (this.root.isPresent()) {
            NodeAndEntries<T, S> nodeAndEntries = this.root.get().delete(entry, all);
            if (nodeAndEntries.node().isPresent() && nodeAndEntries.node().get() == this.root.get()) {
                return this;
            }
            return new RTree<T, S>(nodeAndEntries.node(), this.size - nodeAndEntries.countDeleted() - nodeAndEntries.entriesToAdd().size(), this.context).add(nodeAndEntries.entriesToAdd());
        }
        return this;
    }

    public RTree<T, S> delete(Entry<? extends T, ? extends S> entry) {
        return this.delete(entry, false);
    }

    Iterable<Entry<T, S>> search(Predicate<? super Geometry> condition) {
        if (this.root.isPresent()) {
            return Search.search(this.root.get(), condition);
        }
        return Collections.emptyList();
    }

    public static Predicate<Geometry> intersects(final Rectangle r) {
        return new Predicate<Geometry>(){

            @Override
            public boolean test(Geometry g) {
                return g.intersects(r);
            }
        };
    }

    public Iterable<Entry<T, S>> search(Rectangle r) {
        return this.search(RTree.intersects(r));
    }

    public Iterable<Entry<T, S>> search(Point p) {
        return this.search(p.mbr());
    }

    public <R extends Geometry> Iterable<Entry<T, S>> search(R g, BiPredicate<? super S, ? super R> intersects) {
        return Iterables.filter(this.search(g.mbr()), entry -> intersects.test((Object)entry.geometry(), (Object)g));
    }

    public Iterable<Entry<T, S>> search(final Rectangle r, final double maxDistance) {
        return this.search((Predicate<Geometry>)new Predicate<Geometry>(){

            @Override
            public boolean test(Geometry g) {
                return g.distance(r) < maxDistance;
            }
        });
    }

    public Iterable<Entry<T, S>> search(Point p, double maxDistance) {
        return this.search(p.mbr(), maxDistance);
    }

    public <R extends Geometry> Iterable<Entry<T, S>> search(R g, double maxDistance, BiFunction<? super S, ? super R, Double> distance) {
        return Iterables.filter(this.search((? super Geometry entry) -> entry.distance(g.mbr()) < maxDistance), entry -> (Double)distance.apply((Object)entry.geometry(), (Object)g) < maxDistance);
    }

    public Iterable<Entry<T, S>> nearest(Rectangle r, double maxDistance, int maxCount) {
        BoundedPriorityQueue q = new BoundedPriorityQueue(maxCount, Comparators.ascendingDistance(r));
        for (Entry<T, S> entry : this.search(r, maxDistance)) {
            q.add(entry);
        }
        return q.asOrderedList();
    }

    public Iterable<Entry<T, S>> nearest(Point p, double maxDistance, int maxCount) {
        return this.nearest(p.mbr(), maxDistance, maxCount);
    }

    public Iterable<Entry<T, S>> entries() {
        return this.search(ALWAYS_TRUE);
    }

    public Visualizer visualize(int width, int height, Rectangle view) {
        return new Visualizer(this, width, height, view);
    }

    public Visualizer visualize(int width, int height) {
        return this.visualize(width, height, this.calculateMaxView(this));
    }

    private Rectangle calculateMaxView(RTree<T, S> tree) {
        Iterator<Entry<T, S>> it = tree.entries().iterator();
        Rectangle r = null;
        while (it.hasNext()) {
            Entry<T, S> entry = it.next();
            if (r != null) {
                r = r.add(entry.geometry().mbr());
                continue;
            }
            r = entry.geometry().mbr();
        }
        if (r == null) {
            double[] zero = new double[this.context.dimensions()];
            return Rectangle.create(zero, zero);
        }
        return r;
    }

    public Optional<? extends Node<T, S>> root() {
        return this.root;
    }

    public Optional<Rectangle> mbr() {
        if (!this.root.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.root.get().geometry().mbr());
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public Context<T, S> context() {
        return this.context;
    }

    public String asString() {
        if (!this.root.isPresent()) {
            return "";
        }
        return this.asString(this.root.get(), "");
    }

    private String asString(Node<T, S> node, String margin) {
        StringBuilder s = new StringBuilder();
        s.append(margin);
        s.append("mbr=");
        s.append(node.geometry());
        s.append('\n');
        if (!node.isLeaf()) {
            NonLeaf n = (NonLeaf)node;
            for (int i = 0; i < n.count(); ++i) {
                Node child = n.child(i);
                s.append(this.asString(child, margin + marginIncrement));
            }
        } else {
            Leaf leaf = (Leaf)node;
            for (Entry entry : leaf.entries()) {
                s.append(margin);
                s.append(marginIncrement);
                s.append("entry=");
                s.append(entry);
                s.append('\n');
            }
        }
        return s.toString();
    }

    public int dimensions() {
        return this.context.dimensions();
    }

    public void visit(Visitor<T, S> visitor) {
        if (this.root.isPresent()) {
            this.visit(this.root.get(), visitor);
        }
    }

    private void visit(Node<T, S> node, Visitor<T, S> visitor) {
        if (node.isLeaf()) {
            this.visit((Leaf)node, visitor);
        } else {
            this.visit((NonLeaf)node, visitor);
        }
    }

    private void visit(Leaf<T, S> leaf, Visitor<T, S> visitor) {
        visitor.leaf(leaf);
    }

    private void visit(NonLeaf<T, S> nonLeaf, Visitor<T, S> visitor) {
        visitor.nonLeaf(nonLeaf);
        for (Node<T, S> node : nonLeaf.children()) {
            this.visit(node, visitor);
        }
    }

    public static class Builder {
        private static final double DEFAULT_FILLING_FACTOR = 0.4;
        private static final double DEFAULT_LOADING_FACTOR = 0.7;
        private Optional<Integer> maxChildren = Optional.empty();
        private Optional<Integer> minChildren = Optional.empty();
        private Splitter splitter = SplitterQuadratic.INSTANCE;
        private Selector selector = SelectorMinimalVolumeIncrease.INSTANCE;
        private double loadingFactor = 0.7;
        private boolean star = false;
        private Factory<Object, Geometry> factory = Factory.defaultFactory();
        private int dimensions = 2;

        private Builder() {
        }

        public Builder dimensions(int dimensions) {
            Preconditions.checkArgument(dimensions >= 2, "dimensions must be 2 or more");
            this.dimensions = dimensions;
            return this;
        }

        public Builder loadingFactor(double factor) {
            this.loadingFactor = factor;
            return this;
        }

        public Builder minChildren(int minChildren) {
            this.minChildren = Optional.of(minChildren);
            return this;
        }

        public Builder maxChildren(int maxChildren) {
            this.maxChildren = Optional.of(maxChildren);
            return this;
        }

        public Builder splitter(Splitter splitter) {
            this.splitter = splitter;
            return this;
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder star() {
            this.selector = SelectorRStar.INSTANCE;
            this.splitter = SplitterRStar.INSTANCE;
            this.star = true;
            return this;
        }

        public Builder factory(Factory<?, ? extends Geometry> factory) {
            this.factory = factory;
            return this;
        }

        public <T, S extends Geometry> RTree<T, S> create() {
            this.setDefaultCapacity();
            return new RTree<Object, Geometry>(Optional.empty(), 0, new Context<Object, Geometry>(this.dimensions, this.minChildren.get(), this.maxChildren.get(), this.selector, this.splitter, this.factory));
        }

        public <T, S extends Geometry> RTree<T, S> create(List<Entry<T, S>> entries) {
            this.setDefaultCapacity();
            Context<Object, Geometry> context = new Context<Object, Geometry>(this.dimensions, this.minChildren.get(), this.maxChildren.get(), this.selector, this.splitter, this.factory);
            return this.packingSTR(entries, true, entries.size(), context);
        }

        private void setDefaultCapacity() {
            if (!this.maxChildren.isPresent()) {
                this.maxChildren = this.star ? Optional.of(4) : Optional.of(4);
            }
            if (!this.minChildren.isPresent()) {
                this.minChildren = Optional.of((int)Math.round((double)this.maxChildren.get().intValue() * 0.4));
            }
        }

        private <T, S extends Geometry> RTree<T, S> packingSTR(List<? extends HasGeometry> objects, boolean isLeaf, int size, Context<T, S> context) {
            int capacity = (int)Math.round((double)this.maxChildren.get().intValue() * this.loadingFactor);
            int nodeCount = (int)Math.ceil(1.0 * (double)objects.size() / (double)capacity);
            if (nodeCount == 0) {
                return this.create();
            }
            if (nodeCount == 1) {
                Node<T, S> root = isLeaf ? context.factory().createLeaf(objects, context) : context.factory().createNonLeaf(objects, context);
                return new RTree<T, S>(Optional.of(root), size, context);
            }
            int nodePerSlice = (int)Math.ceil(Math.sqrt(nodeCount));
            int sliceCapacity = nodePerSlice * capacity;
            int sliceCount = (int)Math.ceil(1.0 * (double)objects.size() / (double)sliceCapacity);
            Collections.sort(objects, new MidComparator(0));
            ArrayList<Node<T, S>> nodes = new ArrayList<Node<T, S>>(nodeCount);
            for (int s = 0; s < sliceCount; ++s) {
                List<? extends HasGeometry> slice = objects.subList(s * sliceCapacity, Math.min((s + 1) * sliceCapacity, objects.size()));
                Collections.sort(slice, new MidComparator(1));
                for (int i = 0; i < slice.size(); i += capacity) {
                    if (isLeaf) {
                        List<? extends HasGeometry> entries = slice.subList(i, Math.min(slice.size(), i + capacity));
                        Leaf<T, S> leaf = context.factory().createLeaf(entries, context);
                        nodes.add(leaf);
                        continue;
                    }
                    List<? extends HasGeometry> children = slice.subList(i, Math.min(slice.size(), i + capacity));
                    NonLeaf<T, S> nonleaf = context.factory().createNonLeaf(children, context);
                    nodes.add(nonleaf);
                }
            }
            return this.packingSTR(nodes, false, size, context);
        }

        private record MidComparator(int dimension) implements Comparator<HasGeometry>
        {
            @Override
            public int compare(HasGeometry o1, HasGeometry o2) {
                return Double.compare(this.mid(o1), this.mid(o2));
            }

            private double mid(HasGeometry o) {
                Rectangle mbr = o.geometry().mbr();
                return (mbr.min(this.dimension) + mbr.max(this.dimension)) / 2.0;
            }
        }
    }
}

