/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.geometry;

import com.davidmoten.rtree.geometry.Group;
import com.davidmoten.rtree.geometry.HasGeometry;
import java.util.List;

public final class ListPair<T extends HasGeometry> {
    private final Group<T> group1;
    private final Group<T> group2;
    private double volumeSum = -1.0;
    private final double marginSum;

    public ListPair(List<T> list1, List<T> list2) {
        this.group1 = new Group<T>(list1);
        this.group2 = new Group<T>(list2);
        this.marginSum = this.group1.geometry().mbr().surfaceArea() + this.group2.geometry().mbr().surfaceArea();
    }

    public Group<T> group1() {
        return this.group1;
    }

    public Group<T> group2() {
        return this.group2;
    }

    public double volumeSum() {
        if (this.volumeSum == -1.0) {
            this.volumeSum = this.group1.geometry().mbr().volume() + this.group2.geometry().mbr().volume();
        }
        return this.volumeSum;
    }

    public double marginSum() {
        return this.marginSum;
    }
}

