/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.geometry.internal;

import com.davidmoten.guavamini.Preconditions;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.Rectangle;
import com.davidmoten.rtree.geometry.internal.GeometryUtil;
import com.davidmoten.rtree.internal.util.ObjectsHelper;
import java.util.Arrays;

public final class RectangleDouble
implements Rectangle {
    private final double[] mins;
    private final double[] maxes;

    private RectangleDouble(double[] mins, double[] maxes) {
        Preconditions.checkArgument(mins.length == maxes.length);
        for (int i = 0; i < mins.length; ++i) {
            Preconditions.checkArgument(maxes[i] >= mins[i]);
        }
        this.mins = mins;
        this.maxes = maxes;
    }

    public static RectangleDouble create(double[] mins, double[] maxes) {
        return new RectangleDouble(mins, maxes);
    }

    @Override
    public Rectangle add(Rectangle r) {
        double[] a = new double[this.mins.length];
        double[] b = new double[this.mins.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = RectangleDouble.min(this.mins[i], r.min(i));
            b[i] = RectangleDouble.max(this.maxes[i], r.max(i));
        }
        return new RectangleDouble(a, b);
    }

    @Override
    public boolean contains(double ... p) {
        Preconditions.checkArgument(this.mins.length == p.length);
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i] < this.mins[i]) && !(p[i] > this.maxes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return GeometryUtil.intersects(this.mins, this.maxes, r.mins(), r.maxes());
    }

    @Override
    public double distance(Rectangle r) {
        return GeometryUtil.distance(this.mins, this.maxes, r.mins(), r.maxes());
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    public String toString() {
        return "Rectangle [mins=" + Arrays.toString(this.mins) + ", maxes=" + Arrays.toString(this.maxes) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mins);
        result = 31 * result + Arrays.hashCode(this.maxes);
        return result;
    }

    public boolean equals(Object obj) {
        RectangleDouble other = ObjectsHelper.asClass(obj, RectangleDouble.class);
        if (other != null) {
            return Arrays.equals(this.mins, other.mins) && Arrays.equals(this.maxes, other.maxes);
        }
        return false;
    }

    @Override
    public double intersectionVolume(Rectangle r) {
        if (!this.intersects(r)) {
            return 0.0;
        }
        return RectangleDouble.create(GeometryUtil.max(this.mins, r.mins()), GeometryUtil.min(this.maxes, r.maxes())).volume();
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    private static double max(double a, double b) {
        if (a < b) {
            return b;
        }
        return a;
    }

    private static double min(double a, double b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    @Override
    public double surfaceArea() {
        double sum = 0.0;
        for (int i = 0; i < this.mins.length; ++i) {
            double product = 1.0;
            for (int j = 0; j < this.mins.length; ++j) {
                if (i == j) continue;
                product *= this.maxes[j] - this.mins[j];
            }
            sum += product;
        }
        return 2.0 * sum;
    }

    @Override
    public double volume() {
        double v = 1.0;
        for (int i = 0; i < this.mins.length; ++i) {
            v *= this.maxes[i] - this.mins[i];
        }
        return v;
    }

    @Override
    public double[] mins() {
        return this.mins;
    }

    @Override
    public double[] maxes() {
        return this.maxes;
    }

    @Override
    public int dimensions() {
        return this.mins.length;
    }
}

