/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.internal;

import com.davidmoten.rtree.Context;
import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.Leaf;
import com.davidmoten.rtree.Node;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.Rectangle;
import com.davidmoten.rtree.internal.LeafHelper;
import com.davidmoten.rtree.internal.NodeAndEntries;
import com.davidmoten.rtree.internal.Util;
import java.util.List;

public final class LeafDefault<T, S extends Geometry>
implements Leaf<T, S> {
    private final List<Entry<T, S>> entries;
    private final Rectangle mbr;
    private final Context<T, S> context;

    public LeafDefault(List<Entry<T, S>> entries, Context<T, S> context) {
        this.entries = entries;
        this.context = context;
        this.mbr = Util.mbr(entries);
    }

    @Override
    public Geometry geometry() {
        return this.mbr;
    }

    @Override
    public List<Entry<T, S>> entries() {
        return this.entries;
    }

    @Override
    public int count() {
        return this.entries.size();
    }

    @Override
    public List<Node<T, S>> add(Entry<? extends T, ? extends S> entry) {
        return LeafHelper.add(entry, this);
    }

    @Override
    public NodeAndEntries<T, S> delete(Entry<? extends T, ? extends S> entry, boolean all) {
        return LeafHelper.delete(entry, all, this);
    }

    @Override
    public Context<T, S> context() {
        return this.context;
    }

    @Override
    public Entry<T, S> entry(int i) {
        return this.entries.get(i);
    }

    public String toString() {
        return "LeafDefault [mbr=" + String.valueOf(this.mbr) + ", entries=" + String.valueOf(this.entries) + "]";
    }
}

