/*
 * Decompiled with CFR 0.152.
 */
package com.davidmoten.rtree.internal;

import com.davidmoten.guavamini.Preconditions;
import com.davidmoten.rtree.geometry.HasGeometry;
import com.davidmoten.rtree.geometry.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Util {
    private Util() {
    }

    public static Rectangle mbr(Collection<? extends HasGeometry> items) {
        Preconditions.checkArgument(!items.isEmpty());
        Rectangle result = null;
        for (HasGeometry hasGeometry : items) {
            Rectangle r = hasGeometry.geometry().mbr();
            if (result == null) {
                result = r;
                continue;
            }
            result = result.add(r);
        }
        return result;
    }

    public static <T> List<T> add(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 2);
        result.addAll(list);
        result.add(element);
        return result;
    }

    public static <T> List<T> remove(List<? extends T> list, List<? extends T> elements) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(elements);
        return result;
    }

    public static <T> List<? extends T> replace(List<? extends T> list, T element, List<T> replacements) {
        ArrayList<T> list2 = new ArrayList<T>(list.size() + replacements.size());
        for (T node : list) {
            if (node == element) continue;
            list2.add(node);
        }
        list2.addAll(replacements);
        return list2;
    }
}

