/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client;

import com.radar.radioactive.client.renderer.ScreenWarpRenderer;
import com.radar.radioactive.common.registries.RadEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RadForgeClient {
    private static int shaderLoadCooldown = 0;
    private static float shaderIntensity = 0.0f;
    private static final int FADE_DURATION_TICKS = 300;

    public static float getShaderIntensity() {
        return shaderIntensity;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean hasEffect;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (shaderLoadCooldown > 0) {
            --shaderLoadCooldown;
        }
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = hasEffect = mc.f_91074_ != null && mc.f_91074_.m_21023_((MobEffect)RadEffects.EGO_DISSOLVING.get());
        if (hasEffect) {
            if (shaderIntensity < 1.0f) {
                shaderIntensity += 0.0033333334f;
                shaderIntensity = Math.min(shaderIntensity, 1.0f);
            }
        } else if (shaderIntensity > 0.0f) {
            shaderIntensity -= 0.0033333334f;
            shaderIntensity = Math.max(shaderIntensity, 0.0f);
        }
    }

    @SubscribeEvent
    public static void onClientLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        shaderIntensity = 0.0f;
        ScreenWarpRenderer.resetBuffers();
    }

    @SubscribeEvent
    public static void onClientLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        shaderIntensity = 0.0f;
        ScreenWarpRenderer.resetBuffers();
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
    }
}

