/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.radar.radioactive.client.RadForgeClient;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ScreenWarpRenderer {
    private static ShaderInstance screenWarpShader;
    private static ShaderInstance vfieldShader;
    private static ShaderInstance dispersionShader;
    private static ShaderInstance fluidSimShader;
    private static RenderTarget copyTarget;
    private static RenderTarget vfieldTarget;
    private static RenderTarget fluidPing;
    private static RenderTarget fluidPong;
    private static boolean needsFluidSeed;
    private static RenderTarget feedbackTarget;
    public static final IGuiOverlay OVERLAY;

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) throws IOException {
        screenWarpShader = new ShaderInstance(event.getResourceProvider(), new ResourceLocation("radioactive", "screen_warp"), DefaultVertexFormat.f_85817_);
        event.registerShader(screenWarpShader, shader -> {});
        vfieldShader = new ShaderInstance(event.getResourceProvider(), new ResourceLocation("radioactive", "shadertoy_vfield"), DefaultVertexFormat.f_85817_);
        event.registerShader(vfieldShader, shader -> {});
        dispersionShader = new ShaderInstance(event.getResourceProvider(), new ResourceLocation("radioactive", "shadertoy_dispersion"), DefaultVertexFormat.f_85817_);
        event.registerShader(dispersionShader, shader -> {});
        fluidSimShader = new ShaderInstance(event.getResourceProvider(), new ResourceLocation("radioactive", "screen_fluid_sim"), DefaultVertexFormat.f_85817_);
        event.registerShader(fluidSimShader, shader -> {});
    }

    public static void resetBuffers() {
        if (copyTarget != null) {
            copyTarget.m_83930_();
            copyTarget = null;
        }
        if (vfieldTarget != null) {
            vfieldTarget.m_83930_();
            vfieldTarget = null;
        }
        if (fluidPing != null) {
            fluidPing.m_83930_();
            fluidPing = null;
        }
        if (fluidPong != null) {
            fluidPong.m_83930_();
            fluidPong = null;
        }
        if (feedbackTarget != null) {
            feedbackTarget.m_83930_();
            feedbackTarget = null;
        }
        needsFluidSeed = true;
    }

    static {
        needsFluidSeed = true;
        OVERLAY = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            ShaderInstance vis;
            if (vfieldShader == null || dispersionShader == null) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                return;
            }
            float intensity = RadForgeClient.getShaderIntensity();
            if (intensity <= 0.0f) {
                return;
            }
            RenderTarget main = mc.m_91385_();
            if (copyTarget == null || ScreenWarpRenderer.copyTarget.f_83915_ != main.f_83915_ || ScreenWarpRenderer.copyTarget.f_83916_ != main.f_83916_) {
                if (copyTarget != null) {
                    copyTarget.m_83930_();
                }
                copyTarget = new TextureTarget(main.f_83915_, main.f_83916_, false, true);
                copyTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                needsFluidSeed = true;
            }
            if (vfieldTarget == null || ScreenWarpRenderer.vfieldTarget.f_83915_ != main.f_83915_ || ScreenWarpRenderer.vfieldTarget.f_83916_ != main.f_83916_) {
                if (vfieldTarget != null) {
                    vfieldTarget.m_83930_();
                }
                vfieldTarget = new TextureTarget(main.f_83915_, main.f_83916_, false, true);
                vfieldTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                needsFluidSeed = true;
            }
            if (fluidPing == null || ScreenWarpRenderer.fluidPing.f_83915_ != main.f_83915_ || ScreenWarpRenderer.fluidPing.f_83916_ != main.f_83916_) {
                if (fluidPing != null) {
                    fluidPing.m_83930_();
                }
                fluidPing = new TextureTarget(main.f_83915_, main.f_83916_, false, true);
                fluidPing.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                needsFluidSeed = true;
            }
            if (fluidPong == null || ScreenWarpRenderer.fluidPong.f_83915_ != main.f_83915_ || ScreenWarpRenderer.fluidPong.f_83916_ != main.f_83916_) {
                if (fluidPong != null) {
                    fluidPong.m_83930_();
                }
                fluidPong = new TextureTarget(main.f_83915_, main.f_83916_, false, true);
                fluidPong.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                needsFluidSeed = true;
            }
            if (feedbackTarget == null || ScreenWarpRenderer.feedbackTarget.f_83915_ != main.f_83915_ || ScreenWarpRenderer.feedbackTarget.f_83916_ != main.f_83916_) {
                if (feedbackTarget != null) {
                    feedbackTarget.m_83930_();
                }
                feedbackTarget = new TextureTarget(main.f_83915_, main.f_83916_, false, true);
                feedbackTarget.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            }
            copyTarget.m_83947_(true);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.disableDepthTest();
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
            RenderSystem.setShaderTexture((int)0, (int)main.m_83975_());
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            if (needsFluidSeed) {
                vfieldTarget.m_83947_(true);
                RenderSystem.setShader(() -> vfieldShader);
                RenderSystem.setShaderTexture((int)0, (int)copyTarget.m_83975_());
                if (vfieldShader.m_173348_("OutSize") != null) {
                    vfieldShader.m_173348_("OutSize").m_7971_((float)screenWidth, (float)screenHeight);
                }
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(mat, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
                buffer.m_252986_(mat, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_252986_(mat, (float)screenWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
                tessellator.m_85914_();
                fluidPing.m_83947_(true);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (int)vfieldTarget.m_83975_());
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
                buffer.m_252986_(mat, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
                buffer.m_252986_(mat, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
                buffer.m_252986_(mat, (float)screenWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
                tessellator.m_85914_();
                needsFluidSeed = false;
            }
            fluidPong.m_83947_(true);
            RenderSystem.setShader(() -> fluidSimShader);
            RenderSystem.setShaderTexture((int)0, (int)fluidPing.m_83975_());
            RenderSystem.setShaderTexture((int)1, (ResourceLocation)new ResourceLocation("radioactive", "textures/effect/noise.png"));
            if (fluidSimShader.m_173348_("OutSize") != null) {
                fluidSimShader.m_173348_("OutSize").m_7971_((float)screenWidth, (float)screenHeight);
            }
            if (fluidSimShader.m_173348_("Time") != null) {
                float time = ((float)mc.f_91073_.m_46467_() + partialTick) / 20.0f;
                fluidSimShader.m_173348_("Time").m_5985_(time);
            }
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            RenderTarget tmpRT = fluidPing;
            fluidPing = fluidPong;
            fluidPong = tmpRT;
            main.m_83947_(true);
            RenderSystem.setShader(() -> dispersionShader);
            RenderSystem.setShaderTexture((int)0, (int)fluidPing.m_83975_());
            RenderSystem.setShaderTexture((int)1, (int)copyTarget.m_83975_());
            RenderSystem.setShaderTexture((int)2, (int)feedbackTarget.m_83975_());
            if (dispersionShader.m_173348_("EffectIntensity") != null) {
                dispersionShader.m_173348_("EffectIntensity").m_5985_(intensity);
            }
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            try {
                vis = new ShaderInstance((ResourceProvider)Minecraft.m_91087_().m_91098_(), new ResourceLocation("radioactive", "screen_fluid_vis"), DefaultVertexFormat.f_85817_);
            }
            catch (IOException e) {
                return;
            }
            RenderSystem.setShader(() -> vis);
            RenderSystem.setShaderTexture((int)0, (int)fluidPing.m_83975_());
            if (vis.m_173348_("EffectIntensity") != null) {
                vis.m_173348_("EffectIntensity").m_5985_(intensity);
            }
            if (vis.m_173348_("Time") != null) {
                float time2 = ((float)mc.f_91073_.m_46467_() + partialTick) / 20.0f;
                vis.m_173348_("Time").m_5985_(time2);
            }
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            RenderSystem.enableDepthTest();
            feedbackTarget.m_83947_(true);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderTexture((int)0, (int)main.m_83975_());
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_252986_(mat, 0.0f, 0.0f, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            buffer.m_252986_(mat, 0.0f, (float)screenHeight, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, (float)screenHeight, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_252986_(mat, (float)screenWidth, 0.0f, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
            RenderSystem.enableDepthTest();
        };
    }
}

