/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.radar.radioactive.common.menu.AbstractPoweredMenu;
import com.radar.radioactive.common.network.NetworkHandler;
import com.radar.radioactive.common.network.packets.C2SSetRedstoneModePacket;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPoweredScreen<T extends AbstractPoweredMenu>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("radioactive", "textures/gui/decontaminator_gui.png");
    private static final int ENERGY_BAR_X = 81;
    private static final int ENERGY_BAR_Y = 14;
    private static final int ENERGY_BAR_WIDTH = 14;
    private static final int ENERGY_BAR_HEIGHT = 55;
    private static final int ENERGY_BAR_U = 176;
    private static final int ENERGY_BAR_V = 55;
    private static final int TOOLTIP_X = 81;
    private static final int TOOLTIP_Y = 14;
    private static final int TOOLTIP_WIDTH = 14;
    private static final int TOOLTIP_HEIGHT = 55;
    private Button redstoneModeButton;
    private static final ResourceLocation REDSTONE_TORCH_OFF = new ResourceLocation("minecraft", "textures/block/redstone_torch_off.png");

    public AbstractPoweredScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addRedstoneButton();
    }

    protected void addRedstoneButton() {
        Button btn = Button.m_253074_((Component)Component.m_237119_(), button -> {
            int newMode = (((AbstractPoweredMenu)this.f_97732_).getRedstoneMode() + 1) % 3;
            NetworkHandler.sendToServer(new C2SSetRedstoneModePacket(((AbstractPoweredMenu)this.f_97732_).blockEntity.m_58899_(), newMode));
        }).m_252794_(this.f_97735_ + 150, this.f_97736_ + 20).m_253046_(20, 20).m_253136_();
        this.redstoneModeButton = (Button)this.m_142416_((GuiEventListener)btn);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderEnergyBar(guiGraphics);
    }

    private void renderEnergyBar(GuiGraphics guiGraphics) {
        int scaledEnergy = ((AbstractPoweredMenu)this.f_97732_).getScaledEnergy();
        guiGraphics.m_280218_(TEXTURE, this.f_97735_ + 81, this.f_97736_ + 14 + 55 - scaledEnergy, 176, 55 - scaledEnergy, 14, scaledEnergy);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.renderModeIcons(guiGraphics);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.isMouseOverEnergyBar(mouseX, mouseY)) {
            guiGraphics.m_280666_(this.f_96547_, this.getEnergyTooltip(), mouseX, mouseY);
        }
        if (this.redstoneModeButton != null) {
            int bx = this.redstoneModeButton.m_252754_();
            int by = this.redstoneModeButton.m_252907_();
            int bw = this.redstoneModeButton.m_5711_();
            int bh = this.redstoneModeButton.m_93694_();
            if (mouseX >= bx && mouseX <= bx + bw && mouseY >= by && mouseY <= by + bh) {
                guiGraphics.m_280666_(this.f_96547_, List.of(AbstractPoweredScreen.getRedstoneModeComponent(((AbstractPoweredMenu)this.f_97732_).getRedstoneMode())), mouseX, mouseY);
            }
        }
    }

    protected List<Component> getEnergyTooltip() {
        return List.of(Component.m_237110_((String)"tooltip.radioactive.energy", (Object[])new Object[]{((AbstractPoweredMenu)this.f_97732_).getEnergyStored(), ((AbstractPoweredMenu)this.f_97732_).getMaxEnergyStored()}));
    }

    private boolean isMouseOverEnergyBar(int mouseX, int mouseY) {
        return mouseX >= this.f_97735_ + 81 && mouseX <= this.f_97735_ + 81 + 14 && mouseY >= this.f_97736_ + 14 && mouseY <= this.f_97736_ + 14 + 55;
    }

    private static Component getRedstoneModeComponent(int mode) {
        return Component.m_237115_((String)("tooltip.radioactive.redstone_mode." + mode));
    }

    private void renderModeIcons(GuiGraphics guiGraphics) {
        if (this.redstoneModeButton == null) {
            return;
        }
        int mode = ((AbstractPoweredMenu)this.f_97732_).getRedstoneMode();
        int iconX = this.redstoneModeButton.m_252754_() + (this.redstoneModeButton.m_5711_() - 16) / 2;
        int iconY = this.redstoneModeButton.m_252907_() + (this.redstoneModeButton.m_93694_() - 16) / 2 - 3;
        if (mode == 1) {
            guiGraphics.m_280163_(REDSTONE_TORCH_OFF, iconX, iconY, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            ItemStack stack = this.getIconForRedstoneMode(mode);
            guiGraphics.m_280480_(stack, iconX, iconY);
        }
    }

    private ItemStack getIconForRedstoneMode(int mode) {
        return switch (mode) {
            case 0 -> new ItemStack((ItemLike)Items.f_41978_);
            case 1 -> ItemStack.f_41583_;
            default -> new ItemStack((ItemLike)Items.f_42403_);
        };
    }

    protected void m_267719_() {
        super.m_267719_();
        if (this.redstoneModeButton != null) {
            this.redstoneModeButton.m_264152_(this.f_97735_ + 150, this.f_97736_ + 20);
        }
    }
}

