/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.client.sound;

import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.registries.RadEffects;
import com.radar.radioactive.mixin.SoundEngineAccessor;
import com.radar.radioactive.mixin.SoundManagerAccessor;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SoundMuteHandler {
    private static final ResourceLocation SPECIAL_SOUND_ID = new ResourceLocation("radioactive", "ringing");
    private static boolean effectActive = false;
    private static SoundManager soundManager = null;
    private static SoundEngine soundEngine = null;

    public static void init() {
        if (soundManager == null) {
            soundManager = Minecraft.m_91087_().m_91106_();
            soundEngine = ((SoundManagerAccessor)soundManager).getSoundEngine();
            Radioactive.LOGGER.info("SoundMuteHandler initialized - soundManager: {}, soundEngine: {}", (Object)(soundManager != null ? 1 : 0), (Object)(soundEngine != null ? 1 : 0));
        }
    }

    public static void setEffectActive(boolean active) {
        Radioactive.LOGGER.debug("Setting sound mute effect active: {}", (Object)active);
        effectActive = active;
    }

    private static float calculateLogVolume(float progress) {
        return (float)(Math.exp(-3.0f * progress) * (double)0.9f + (double)0.1f);
    }

    public static void updateMute() {
        if (!effectActive || soundEngine == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !mc.f_91074_.m_21023_((MobEffect)RadEffects.IMPENDING_DEATH.get())) {
            return;
        }
        int duration = mc.f_91074_.m_21124_((MobEffect)RadEffects.IMPENDING_DEATH.get()).m_19557_();
        float progress = 1.0f - (float)duration / 200.0f;
        Map<SoundInstance, ChannelAccess.ChannelHandle> instanceMap = ((SoundEngineAccessor)soundEngine).getInstanceToChannel();
        Radioactive.LOGGER.debug("Updating sound mute - active sounds: {}", (Object)instanceMap.size());
        float volumeMultiplier = SoundMuteHandler.calculateLogVolume(progress);
        for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry : instanceMap.entrySet()) {
            SoundInstance instance = entry.getKey();
            if (instance == null) continue;
            Radioactive.LOGGER.debug("Processing sound: {}", (Object)instance.m_7904_());
            ChannelAccess.ChannelHandle channelHandle = entry.getValue();
            if (channelHandle == null) continue;
            float baseVolume = ((SoundEngineAccessor)soundEngine).invokeCalculateVolume(instance);
            if (SPECIAL_SOUND_ID.equals((Object)instance.m_7904_())) {
                channelHandle.m_120154_(channel -> channel.m_83666_(baseVolume));
                continue;
            }
            float newVolume = baseVolume * volumeMultiplier;
            channelHandle.m_120154_(channel -> channel.m_83666_(newVolume));
        }
    }
}

