/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public abstract class AbstractPoweredBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ItemStackHandler itemHandler;
    protected final EnergyStorage energyStorage;
    protected LazyOptional<IItemHandler> lazyItemHandler;
    protected LazyOptional<IEnergyStorage> lazyEnergyHandler;
    protected int progress;
    protected int maxProgress;
    protected int redstoneMode = 0;
    protected boolean autoShutOff = false;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AbstractPoweredBlockEntity.this.progress;
                case 1 -> AbstractPoweredBlockEntity.this.maxProgress;
                case 2 -> AbstractPoweredBlockEntity.this.energyStorage.getEnergyStored();
                case 3 -> AbstractPoweredBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 4 -> AbstractPoweredBlockEntity.this.redstoneMode;
                case 5 -> {
                    if (AbstractPoweredBlockEntity.this.autoShutOff) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractPoweredBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    AbstractPoweredBlockEntity.this.maxProgress = value;
                    break;
                }
                case 4: {
                    AbstractPoweredBlockEntity.this.redstoneMode = value;
                    break;
                }
                case 5: {
                    AbstractPoweredBlockEntity.this.autoShutOff = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    public AbstractPoweredBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int itemSlots, int energyCapacity, int maxTransfer, boolean isCreative) {
        super(type, pos, state);
        this.itemHandler = new ItemStackHandler(itemSlots);
        this.energyStorage = isCreative ? new CreativeEnergyStorage() : new ModEnergyStorage(energyCapacity, maxTransfer);
        this.lazyItemHandler = LazyOptional.empty();
        this.lazyEnergyHandler = LazyOptional.empty();
    }

    public void setRedstoneMode(int mode) {
        this.redstoneMode = Math.clamp((int)mode, (int)0, (int)2);
        this.m_6596_();
    }

    public void toggleAutoShutOff() {
        this.autoShutOff = !this.autoShutOff;
        this.m_6596_();
    }

    protected boolean canActivateBasedOnRedstone(Level level, BlockPos pos) {
        boolean hasSignal = level.m_276867_(pos);
        return switch (this.redstoneMode) {
            case 0 -> hasSignal;
            case 1 -> {
                if (!hasSignal) {
                    yield true;
                }
                yield false;
            }
            case 2 -> false;
            default -> false;
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("machine.progress", this.progress);
        nbt.m_128405_("machine.maxProgress", this.maxProgress);
        nbt.m_128405_("machine.energyStored", this.energyStorage.getEnergyStored());
        nbt.m_128405_("machine.redstoneMode", this.redstoneMode);
        nbt.m_128379_("machine.autoShutOff", this.autoShutOff);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("machine.progress");
        this.maxProgress = nbt.m_128451_("machine.maxProgress");
        ((ModEnergyStorage)this.energyStorage).setEnergyStored(nbt.m_128451_("machine.energyStored"));
        this.redstoneMode = nbt.m_128451_("machine.redstoneMode");
        this.autoShutOff = nbt.m_128471_("machine.autoShutOff");
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state) {
    }

    @NotNull
    public abstract Component m_5446_();

    public abstract AbstractContainerMenu m_7208_(int var1, @NotNull Inventory var2, @NotNull Player var3);

    public ContainerData getContainerData() {
        return this.data;
    }

    private static class CreativeEnergyStorage
    extends ModEnergyStorage {
        public CreativeEnergyStorage() {
            super(50000, Integer.MAX_VALUE);
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return maxExtract;
        }

        public int getEnergyStored() {
            return this.getMaxEnergyStored();
        }
    }

    private static class ModEnergyStorage
    extends EnergyStorage {
        public ModEnergyStorage(int capacity, int maxTransfer) {
            super(capacity, maxTransfer);
        }

        public void setEnergyStored(int amount) {
            this.energy = Math.clamp((int)amount, (int)0, (int)this.capacity);
        }
    }
}

