/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.blockentities;

import com.radar.radioactive.client.sound.DecontaminatorSoundInstance;
import com.radar.radioactive.common.blockentities.AbstractPoweredBlockEntity;
import com.radar.radioactive.common.menu.DecontaminatorMenu;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.registries.RadBlockEntities;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DecontaminatorBlockEntity
extends AbstractPoweredBlockEntity {
    private static final int BASE_ENERGY_USAGE_PER_TICK = 20;
    private static final float RADIATION_REDUCTION_PER_TICK = 5.0f;
    private static final Random RANDOM = new Random();
    private static final int PARTICLES_PER_TICK = 3;
    private static final double PARTICLE_SPEED = 0.05;
    private static final double PARTICLE_SPREAD = 0.25;
    protected int deconSize = 3;
    @OnlyIn(value=Dist.CLIENT)
    private DecontaminatorSoundInstance decontaminatorSound;

    public DecontaminatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RadBlockEntities.DECONTAMINATOR.get(), pos, state, 0, 10000, 100, false);
        this.maxProgress = 100;
    }

    @Override
    public ContainerData getContainerData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return index == 6 ? DecontaminatorBlockEntity.this.deconSize : DecontaminatorBlockEntity.this.data.m_6413_(index);
            }

            public void m_8050_(int index, int value) {
                if (index == 6) {
                    DecontaminatorBlockEntity.this.setDeconSize(value);
                } else {
                    DecontaminatorBlockEntity.this.data.m_8050_(index, value);
                }
            }

            public int m_6499_() {
                return 7;
            }
        };
    }

    public void setDeconSize(int size) {
        this.deconSize = switch (size) {
            case 1, 5 -> size;
            default -> 3;
        };
        this.m_6596_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DecontaminatorBlockEntity entity) {
        if (level.m_5776_()) {
            entity.clientTick(level, pos, state);
        } else {
            entity.serverTick(level, pos, state);
        }
    }

    private static AABB getDecontaminationArea(BlockPos pos, int size) {
        int half = size / 2;
        return new AABB(pos.m_7918_(-half, 1, -half), pos.m_7918_(half + 1, size + 1, half + 1));
    }

    private static void spawnDecontaminationParticles(Level level, BlockPos pos, BlockState state, int size) {
        Direction facing = Direction.UP;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        x += (double)facing.m_122429_() * 0.55;
        y += (double)facing.m_122430_() * 0.55;
        z += (double)facing.m_122431_() * 0.55;
        double spreadScale = (double)size / 3.0;
        for (int i = 0; i < 3; ++i) {
            double spreadX = 0.0;
            double spreadY = 0.0;
            double spreadZ = 0.0;
            if (facing.m_122434_() != Direction.Axis.X) {
                spreadX = (RANDOM.nextDouble() - 0.5) * 0.25 * spreadScale;
            }
            if (facing.m_122434_() != Direction.Axis.Y) {
                spreadY = (RANDOM.nextDouble() - 0.5) * 0.25 * spreadScale;
            }
            if (facing.m_122434_() != Direction.Axis.Z) {
                spreadZ = (RANDOM.nextDouble() - 0.5) * 0.25 * spreadScale;
            }
            double motionX = (double)facing.m_122429_() * 0.05;
            double motionY = (double)facing.m_122430_() * 0.05;
            double motionZ = (double)facing.m_122431_() * 0.05;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123806_, x + spreadX, y + spreadY, z + spreadZ, motionX += (RANDOM.nextDouble() - 0.5) * 0.01, motionY += (RANDOM.nextDouble() - 0.5) * 0.01, motionZ += (RANDOM.nextDouble() - 0.5) * 0.01);
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        boolean needsWork;
        boolean canActivate = this.canActivateBasedOnRedstone(level, pos);
        AABB area = DecontaminatorBlockEntity.getDecontaminationArea(pos, this.deconSize);
        List playersInRange = level.m_45976_(Player.class, area);
        boolean bl = needsWork = !this.autoShutOff;
        if (this.autoShutOff) {
            needsWork = false;
            for (Player player : playersInRange) {
                if (!(RadiationHelper.getRadiation((LivingEntity)player) > 0.0f)) continue;
                needsWork = true;
                break;
            }
        }
        int energyUsage = (int)(20.0 * Math.pow(this.deconSize, 3.0) / 27.0);
        if (canActivate && needsWork && this.energyStorage.getEnergyStored() >= energyUsage) {
            this.energyStorage.extractEnergy(energyUsage, false);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
            for (Player player : playersInRange) {
                float currentRadiation = RadiationHelper.getRadiation((LivingEntity)player);
                if (!(currentRadiation > 0.0f)) continue;
                RadiationHelper.addRadiation((LivingEntity)player, -Math.min(5.0f, currentRadiation));
            }
            this.progress = (this.progress + 1) % this.maxProgress;
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
            this.progress = 0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            DecontaminatorBlockEntity.spawnDecontaminationParticles(level, pos, state, this.deconSize);
            if (this.decontaminatorSound == null || this.decontaminatorSound.m_7801_()) {
                this.decontaminatorSound = new DecontaminatorSoundInstance(this);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.decontaminatorSound);
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("machine.deconSize", this.deconSize);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.deconSize = nbt.m_128451_("machine.deconSize");
        if (this.deconSize != 1 && this.deconSize != 3 && this.deconSize != 5) {
            this.deconSize = 3;
        }
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.radioactive.decontaminator");
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new DecontaminatorMenu(id, inv, this, this.getContainerData());
    }

    @Override
    public void drops() {
        super.drops();
    }

    public void m_7651_() {
        super.m_7651_();
    }
}

