/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.blockentities;

import com.radar.radioactive.client.sound.RadiationAbsorberSoundInstance;
import com.radar.radioactive.common.blockentities.AbstractPoweredBlockEntity;
import com.radar.radioactive.common.menu.RadiationAbsorberMenu;
import com.radar.radioactive.common.network.NetworkHandler;
import com.radar.radioactive.common.radiation.spatial.GlobalRadiationIndexAPI;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistryAPI;
import com.radar.radioactive.common.registries.RadBlockEntities;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadiationAbsorberBlockEntity
extends AbstractPoweredBlockEntity {
    private static final int ENERGY_USAGE_PER_CHUNK = 20;
    private static final float RADIATION_ABSORPTION_RATE = 1.0f;
    private final int tier;
    @OnlyIn(value=Dist.CLIENT)
    private RadiationAbsorberSoundInstance radiationAbsorberSound;

    public RadiationAbsorberBlockEntity(BlockPos pos, BlockState state, int tier, boolean isCreative) {
        super((BlockEntityType)RadBlockEntities.RADIATION_ABSORBER.get(), pos, state, 0, 10000 * (int)Math.pow(tier * 2 - 1, 2.0), 100 * tier, isCreative);
        this.tier = tier;
        this.maxProgress = 100;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RadiationAbsorberBlockEntity entity) {
        if (level.m_5776_()) {
            entity.clientTick(level, pos, state);
        } else {
            entity.serverTick(level, pos, state);
        }
    }

    private static void forEachChunk(ChunkPos center, int range, Consumer<ChunkPos> fn) {
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                fn.accept(new ChunkPos(center.f_45578_ + dx, center.f_45579_ + dz));
            }
        }
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state) {
        boolean hasSufficientEnergy;
        boolean needsWork;
        if (level.m_5776_()) {
            return;
        }
        boolean canActivate = this.canActivateBasedOnRedstone(level, pos);
        boolean isCurrentlyOn = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
        int range = this.tier - 1;
        ChunkPos center = new ChunkPos(pos);
        int chunks = (int)Math.pow(range * 2 + 1, 2.0);
        float efficiencyFactor = 0.5f * (float)this.tier + 0.5f;
        int energyNeededPerTick = (int)Math.ceil((float)(20 * chunks) / efficiencyFactor);
        boolean bl = needsWork = !this.autoShutOff;
        if (this.autoShutOff) {
            needsWork = false;
            block0: for (int dx = -range; dx <= range; ++dx) {
                for (int dz = -range; dz <= range; ++dz) {
                    ChunkPos cp2 = new ChunkPos(center.f_45578_ + dx, center.f_45579_ + dz);
                    if (!GlobalRadiationIndexAPI.findDynamicSource((ServerLevel)level, cp2).isPresent()) continue;
                    needsWork = true;
                    break block0;
                }
            }
        }
        boolean bl2 = hasSufficientEnergy = this.energyStorage.extractEnergy(energyNeededPerTick, true) == energyNeededPerTick;
        if (canActivate && needsWork && !isCurrentlyOn && hasSufficientEnergy) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
            SafeChunkRegistryAPI.modifyRange(level, center, range, true);
            RadiationAbsorberBlockEntity.forEachChunk(center, range, cp -> NetworkHandler.sendSafeChunkPacketToClients(level, cp, true));
        } else if (!(canActivate && needsWork && hasSufficientEnergy || !isCurrentlyOn)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
            SafeChunkRegistryAPI.modifyRange(level, center, range, false);
            RadiationAbsorberBlockEntity.forEachChunk(center, range, cp -> NetworkHandler.sendSafeChunkPacketToClients(level, cp, false));
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.energyStorage.extractEnergy(energyNeededPerTick, false);
            this.progress = (this.progress + 1) % this.maxProgress;
        } else {
            this.progress = 0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            this.spawnAbsorptionParticles(level, pos);
            if (this.radiationAbsorberSound == null || this.radiationAbsorberSound.m_7801_()) {
                this.radiationAbsorberSound = new RadiationAbsorberSoundInstance(this);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)this.radiationAbsorberSound);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnAbsorptionParticles(Level level, BlockPos pos) {
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 0.5;
        double centerZ = (double)pos.m_123343_() + 0.5;
        for (int i = 0; i < 3; ++i) {
            double spreadX = (level.f_46441_.m_188500_() - 0.5) * 0.25;
            double spreadY = (level.f_46441_.m_188500_() - 0.5) * 0.25;
            double spreadZ = (level.f_46441_.m_188500_() - 0.5) * 0.25;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, centerX + spreadX, centerY + spreadY, centerZ + spreadZ, 0.0, 0.05, 0.0);
        }
    }

    @Override
    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.radioactive.radiation_absorber");
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new RadiationAbsorberMenu(id, inv, this, this.getContainerData());
    }

    @Override
    public void drops() {
        super.drops();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            BlockState currentState = this.m_58900_();
            boolean isLitOnLoad = (Boolean)currentState.m_61143_((Property)BlockStateProperties.f_61443_);
            int range = this.tier - 1;
            ChunkPos center = new ChunkPos(this.f_58858_);
            SafeChunkRegistryAPI.modifyRange(this.f_58857_, center, range, isLitOnLoad);
            RadiationAbsorberBlockEntity.forEachChunk(center, range, cp -> NetworkHandler.sendSafeChunkPacketToClients(this.f_58857_, cp, isLitOnLoad));
        }
    }
}

