/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.blocks;

import com.radar.radioactive.common.radiation.RadiationHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BioScannerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public BioScannerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, POWER, POWERED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_()) && !pLevel.m_5776_()) {
            pLevel.m_186460_(pPos, (Block)this, 4);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.updateSignal(pState, (Level)pLevel, pPos);
        pLevel.m_186460_(pPos, (Block)this, 20);
    }

    protected void updateSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        float maxPlayerRadForSignal;
        int signalStrength;
        boolean isPowered;
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        BlockPos scanCenter = pPos.m_5484_(facing, 3);
        AABB scanArea = new AABB(scanCenter).m_82377_(2.0, 1.0, 2.0);
        List playersInArea = pLevel.m_6443_(Player.class, scanArea, player -> !player.m_5833_() && player.m_6084_());
        float maxPlayerRadiation = 0.0f;
        if (!playersInArea.isEmpty()) {
            for (Player player2 : playersInArea) {
                float playerRad = RadiationHelper.getRadiation((LivingEntity)player2);
                if (!(playerRad > maxPlayerRadiation)) continue;
                maxPlayerRadiation = playerRad;
            }
        }
        boolean bl = isPowered = (signalStrength = (int)Math.min(15.0, Math.floor(15.0f * (maxPlayerRadiation / (maxPlayerRadForSignal = 1000.0f))))) > 0;
        if ((Integer)pState.m_61143_((Property)POWER) != signalStrength) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(signalStrength))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
            pLevel.m_46672_(pPos, (Block)this);
        }
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return (Integer)pBlockState.m_61143_((Property)POWER);
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Integer)pBlockState.m_61143_((Property)POWER);
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pBlockState.m_61143_((Property)FACING) == pSide ? pBlockState.m_60746_(pBlockAccess, pPos, pSide) : 0;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return null;
    }
}

