/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.blocks;

import com.radar.radioactive.common.radiation.capabilities.RadiationCapabilities;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;

public class GeigerCounterBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public GeigerCounterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, POWER, POWERED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pOldState.m_60713_(pState.m_60734_()) && !pLevel.m_5776_()) {
            pLevel.m_186460_(pPos, (Block)this, 4);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.updateSignal(pLevel, pPos);
        pLevel.m_186460_(pPos, (Block)this, 20);
    }

    protected void updateSignal(ServerLevel pLevel, BlockPos pPos) {
        AtomicReference<Float> totalRadiation = new AtomicReference<Float>(Float.valueOf(0.0f));
        float scanRadius = 48.0f;
        ChunkPos centerChunkPos = new ChunkPos(pPos);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                ChunkPos currentChunkPos = new ChunkPos(centerChunkPos.f_45578_ + x, centerChunkPos.f_45579_ + z);
                LevelChunk chunk = pLevel.m_7726_().m_7131_(currentChunkPos.f_45578_, currentChunkPos.f_45579_);
                if (chunk == null) continue;
                chunk.getCapability(RadiationCapabilities.CHUNK_RADIATION).ifPresent(cap -> {
                    float fluxFromChunk = cap.getIndex().flux(pPos.m_252807_(), scanRadius, null, pLevel);
                    totalRadiation.updateAndGet(v -> Float.valueOf(v.floatValue() + fluxFromChunk));
                });
            }
        }
        float maxRadForSignal = 100.0f;
        float curveFactor = 99.0f;
        float normalizedRadiation = totalRadiation.get().floatValue() / maxRadForSignal;
        double scaledValue = Math.log1p((normalizedRadiation = Math.max(0.0f, Math.min(1.0f, normalizedRadiation))) * curveFactor) / Math.log1p(curveFactor);
        int signalStrength = (int)Math.floor(scaledValue * 15.0);
        boolean isPowered = signalStrength > 0;
        signalStrength = Math.max(0, Math.min(15, signalStrength));
        BlockState currentState = pLevel.m_8055_(pPos);
        if (currentState.m_60713_((Block)this) && (Integer)currentState.m_61143_((Property)POWER) != signalStrength) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)currentState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(signalStrength))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
            pLevel.m_46672_(pPos, (Block)this);
        }
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return (Integer)pBlockState.m_61143_((Property)POWER);
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Integer)pBlockState.m_61143_((Property)POWER);
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return pBlockState.m_61143_((Property)FACING) == pSide ? pBlockState.m_60746_(pBlockAccess, pPos, pSide) : 0;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return null;
    }
}

