/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.events;

import com.radar.radioactive.common.Radioactive;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventBusEvents {
    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            try {
                IModFileInfo modFileInfo = ModList.get().getModFileById("radioactive");
                if (modFileInfo == null) {
                    Radioactive.LOGGER.error("Could not find Radioactive mod file info; built-in resource packs will be missing!");
                    return;
                }
                IModFile modFile = modFileInfo.getFile();
                Path resourcePath = modFile.findResource(new String[]{"radioactive_dev_art_pack"});
                event.addRepositorySource(packConsumer -> {
                    Pack pack = Pack.m_245429_((String)"radioactive:dev_art", (Component)Component.m_237113_((String)"Radioactive: Dev Art"), (boolean)false, packId -> new PathPackResources(packId, resourcePath, false), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    if (pack != null) {
                        packConsumer.accept(pack);
                    }
                });
            }
            catch (Exception e) {
                Radioactive.LOGGER.error("Error adding built-in resource pack", (Throwable)e);
            }
        }
    }
}

