/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.items;

import com.radar.radioactive.client.model.ModArmPoses;
import com.radar.radioactive.client.renderer.item.RendererRadX;
import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.items.ItemBaseGeo;
import com.radar.radioactive.common.registries.RadEffects;
import com.radar.radioactive.common.registries.RadSounds;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemRadX
extends ItemBaseGeo
implements IForgeItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int RADX_BAR_COLOR = 6094643;
    private final int duration;
    private final int tier;

    public ItemRadX(Item.Properties properties, int duration, int tier) {
        super(properties.m_41503_(3));
        this.duration = duration;
        this.tier = tier;
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entityLiving) {
        if (!level.f_46443_ && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (player.m_21023_((MobEffect)RadEffects.RADIATION_RESISTANCE.get()) && !player.m_21023_((MobEffect)RadEffects.WOOZY.get())) {
                MobEffectInstance existingEffect = player.m_21124_((MobEffect)RadEffects.RADIATION_RESISTANCE.get());
                if (existingEffect.m_19564_() < (Integer)RadioactiveCommonConfigs.RAD_X_CAP_AMOUNT.get()) {
                    int amplifier = existingEffect.m_19564_() + 1;
                    player.m_7292_(new MobEffectInstance((MobEffect)RadEffects.RADIATION_RESISTANCE.get(), 2400, amplifier, false, false, true));
                } else if (existingEffect.m_19564_() >= (Integer)RadioactiveCommonConfigs.RAD_X_CAP_AMOUNT.get()) {
                    player.m_7292_(new MobEffectInstance((MobEffect)RadEffects.WOOZY.get(), 1200, this.tier - 1, false, false, true));
                    player.m_21195_((MobEffect)RadEffects.RADIATION_RESISTANCE.get());
                }
            } else if (!player.m_21023_((MobEffect)RadEffects.WOOZY.get())) {
                player.m_7292_(new MobEffectInstance((MobEffect)RadEffects.RADIATION_RESISTANCE.get(), 2400, 0, false, false, true));
            }
            level.m_5594_(null, player.m_20183_(), (SoundEvent)RadSounds.PILLS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            }
        }
        return stack;
    }

    @Override
    protected void addBaseTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.radioactive.radx.info", (Object[])new Object[]{String.format("%.1f", (double)this.duration / 20.0)}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    protected void addShiftTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.radioactive.radx.info", (Object[])new Object[]{String.format("%.1f", (double)this.duration / 20.0)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237110_((String)"tooltip.radioactive.radx.uses", (Object[])new Object[]{this.getMaxDamage(stack) - stack.m_41773_(), this.getMaxDamage(stack)}).m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.radx.warning").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack stack) {
                if (entity.m_21211_() == stack && entity.m_21212_() > 0) {
                    return ModArmPoses.TAKE_PILLS;
                }
                return super.getArmPose(entity, hand, stack);
            }
        });
        consumer.accept(new IClientItemExtensions(){
            private RendererRadX renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new RendererRadX();
                }
                return this.renderer;
            }
        });
    }

    public int m_142159_(ItemStack pStack) {
        return 6094643;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public int m_8105_(ItemStack stack) {
        return 10;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

