/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.items;

import com.radar.radioactive.client.model.ModArmPoses;
import com.radar.radioactive.client.renderer.item.RendererRadaway;
import com.radar.radioactive.common.items.ItemWithShiftTooltip;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.registries.RadDamageTypes;
import com.radar.radioactive.common.registries.RadEffects;
import com.radar.radioactive.common.registries.RadSounds;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ItemRadaway
extends ItemWithShiftTooltip
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final DecimalFormat RADIATION_FORMAT = new DecimalFormat("0.#");
    private final float radiationReduction;
    private final int useDuration;
    private final String tier;

    public ItemRadaway(Item.Properties properties, float radiationReduction, int useDuration, String tier) {
        super(properties);
        this.radiationReduction = radiationReduction;
        this.useDuration = useDuration;
        this.tier = tier;
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    protected void addBaseTooltip(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.radioactive.radaway_reduction", (Object[])new Object[]{RADIATION_FORMAT.format(this.radiationReduction)}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    protected void addShiftTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.radaway_shift").m_130940_(ChatFormatting.GRAY));
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack stack) {
                if (entity.m_21211_() == stack && entity.m_21212_() > 0) {
                    return ModArmPoses.INJECT_BLOOD;
                }
                return super.getArmPose(entity, hand, stack);
            }
        });
        consumer.accept(new IClientItemExtensions(){
            private RendererRadaway renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new RendererRadaway();
                }
                return this.renderer;
            }
        });
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return this.useDuration;
    }

    public boolean m_5812_(ItemStack stack) {
        return this.tier.equals("ultimate");
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (pPlayer.m_36335_().m_41519_((Item)this)) {
            return InteractionResult.FAIL;
        }
        if (pInteractionTarget instanceof Player) {
            Player targetPlayer = (Player)pInteractionTarget;
            if (!pPlayer.m_9236_().m_5776_()) {
                Level level = pPlayer.m_9236_();
                pPlayer.m_36335_().m_41524_((Item)this, 20);
                level.m_9598_().m_175515_(Registries.f_268580_).m_203636_(RadDamageTypes.SYRINGE).ifPresent(holder -> {
                    DamageSource source = new DamageSource((Holder)holder, (Entity)pPlayer);
                    targetPlayer.m_6469_(source, 1.0f);
                });
                this.useItem(pPlayer, targetPlayer, pStack);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (pLivingEntity instanceof Player) {
            Player pPlayer = (Player)pLivingEntity;
            if (!pLevel.m_5776_()) {
                pPlayer.m_36335_().m_41524_((Item)this, 20);
                this.useItem(pPlayer, pPlayer, pStack);
            }
        }
        return super.m_5922_(pStack, pLevel, pLivingEntity);
    }

    public String getTier() {
        return this.tier;
    }

    private void useItem(Player applier, Player target, ItemStack stack) {
        float currentRadiation = RadiationHelper.getRadiation((LivingEntity)target);
        double newRadiation = Math.max(0.0f, currentRadiation - this.radiationReduction);
        RadiationHelper.addRadiation((LivingEntity)target, -this.radiationReduction);
        if (newRadiation <= 0.0) {
            target.m_21195_((MobEffect)RadEffects.RADIATION_POISONING.get());
        }
        int nauseaDuration = switch (this.tier) {
            case "basic" -> 200;
            case "advanced" -> 100;
            case "ultimate" -> 60;
            default -> 200;
        };
        target.m_5496_((SoundEvent)RadSounds.RADAWAY_USE.get(), 1.0f, 1.0f);
        target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, nauseaDuration));
        target.m_5496_((SoundEvent)RadSounds.RADAWAY_USE.get(), 1.0f, 1.0f);
        if (!applier.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

