/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.items;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.items.ItemWithShiftTooltip;
import com.radar.radioactive.common.network.NetworkHandler;
import com.radar.radioactive.common.network.packets.S2CGeigerBrokenPacket;
import com.radar.radioactive.common.network.packets.S2CGeigerUpdatePacket;
import com.radar.radioactive.common.radiation.RadiationHelper;
import com.radar.radioactive.common.registries.RadSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ItemShoddyGeigerCounter
extends ItemWithShiftTooltip
implements ICurioItem {
    private static final int TICK_INTERVAL = 15;
    public static final String KEY_LAST_READING = "last_reading";
    private static final String KEY_QUALITY = "quality";
    private static final String KEY_TICK_COUNTER = "tick_counter";
    public static final String KEY_BROKEN = "broken";
    private static final int DURABILITY = 500;
    private final float RADIOACTIVE_RATE_LIMIT = 30.0f;

    public ItemShoddyGeigerCounter(Item.Properties properties) {
        super(properties.m_41503_(500));
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean isHeld = player.m_21205_() == stack || player.m_21206_() == stack;
        boolean inHotbar = false;
        if (!isHeld) {
            for (int i = 0; i < 9; ++i) {
                if (player.m_150109_().m_8020_(i) != stack) continue;
                inHotbar = true;
                break;
            }
        }
        if (isHeld || inHotbar) {
            this.doGeigerCounter(stack, player, level);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.doGeigerCounter(stack, player, player.m_9236_());
        }
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        RandomSource random = pLevel.m_213780_();
        CompoundTag tag = pStack.m_41784_();
        if (!tag.m_128441_(KEY_LAST_READING)) {
            tag.m_128350_(KEY_LAST_READING, 0.0f);
        }
        if (!tag.m_128441_(KEY_QUALITY)) {
            tag.m_128350_(KEY_QUALITY, random.m_188501_());
        }
        if (!tag.m_128441_(KEY_BROKEN)) {
            tag.m_128379_(KEY_BROKEN, false);
        }
        if (!tag.m_128441_(KEY_TICK_COUNTER)) {
            tag.m_128405_(KEY_TICK_COUNTER, 0);
        }
        pStack.m_41751_(tag);
    }

    private void doGeigerCounter(ItemStack stack, Player player, Level level) {
        float quality;
        CompoundTag tag = stack.m_41784_();
        int tickCounter = tag.m_128451_(KEY_TICK_COUNTER);
        ++tickCounter;
        if (!tag.m_128441_(KEY_BROKEN)) {
            tag.m_128379_(KEY_BROKEN, false);
        }
        if (!tag.m_128441_(KEY_QUALITY)) {
            tag.m_128350_(KEY_QUALITY, level.m_213780_().m_188501_());
        }
        if ((quality = tag.m_128457_(KEY_QUALITY)) > 1.0f) {
            quality = Math.min(1.0f, quality);
            tag.m_128350_(KEY_QUALITY, quality);
        }
        if ((float)tickCounter < 15.0f - 10.0f * quality) {
            tag.m_128405_(KEY_TICK_COUNTER, tickCounter);
            return;
        }
        tag.m_128405_(KEY_TICK_COUNTER, 0);
        if (!level.f_46443_) {
            boolean isNowBroken;
            float storedRadiation = RadiationHelper.getRadiation((LivingEntity)player);
            float exposureRate = RadiationHelper.getRadiationRate((LivingEntity)player);
            float shielding = RadiationHelper.getRadiationResistance((LivingEntity)player);
            float realEffectiveRate = exposureRate * (1.0f - shielding);
            float maxError = 0.8f;
            float errorMargin = maxError * (1.0f - quality);
            float error = (level.m_213780_().m_188501_() - 0.5f) * 2.0f * errorMargin;
            float finalReading = Math.max(0.0f, realEffectiveRate * (1.0f + error));
            tag.m_128350_(KEY_LAST_READING, finalReading);
            boolean wasBroken = tag.m_128471_(KEY_BROKEN);
            if (!wasBroken && (double)realEffectiveRate >= 30.0 * (0.5 + (double)quality)) {
                int damageRate = 1 + (int)(10.0f * realEffectiveRate / 30.0f);
                stack.m_41721_(stack.m_41773_() + damageRate);
            }
            boolean bl = isNowBroken = stack.m_41773_() >= stack.m_41776_() - 1;
            if (isNowBroken && !wasBroken) {
                stack.m_41721_(stack.m_41776_() - 1);
                tag.m_128379_(KEY_BROKEN, true);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)RadSounds.TUBE_BREAK.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (level.m_213780_().m_188501_() - 0.5f) * 0.2f);
                NetworkHandler.sendToPlayer(new S2CGeigerBrokenPacket(true), (ServerPlayer)player);
            } else if (!isNowBroken && wasBroken) {
                tag.m_128379_(KEY_BROKEN, false);
                NetworkHandler.sendToPlayer(new S2CGeigerBrokenPacket(false), (ServerPlayer)player);
            }
            if (((Boolean)RadioactiveCommonConfigs.ENABLE_GEIGER_SOUNDS.get()).booleanValue() && !isNowBroken) {
                this.playGeigerSound(level, player, finalReading, quality);
            }
            S2CGeigerUpdatePacket packet = new S2CGeigerUpdatePacket(true, storedRadiation, finalReading, finalReading);
            NetworkHandler.sendToPlayer(packet, (ServerPlayer)player);
        }
    }

    private void playGeigerSound(Level level, Player player, float reading, float quality) {
        if (level.m_5776_()) {
            return;
        }
        RandomSource random = level.m_213780_();
        float soundInaccuracy = (1.0f - quality) * 0.5f;
        float soundError = 1.0f + (random.m_188501_() - 0.5f) * soundInaccuracy;
        float clickChance = Math.min(1.0f, reading / 40.0f) * soundError;
        if (random.m_188501_() < clickChance) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)RadSounds.GEIGER_CLICK.get(), SoundSource.PLAYERS, ((Double)RadioactiveCommonConfigs.GEIGER_SOUND_VOLUME.get()).floatValue(), 1.0f + (random.m_188501_() - 0.5f) * 0.2f);
        } else if (random.m_188503_(5) == 0) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)RadSounds.GEIGER_CLICK.get(), SoundSource.PLAYERS, ((Double)RadioactiveCommonConfigs.GEIGER_SOUND_VOLUME.get()).floatValue() * 0.5f, 1.0f);
        }
    }

    @Override
    protected void addBaseTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        float lastRadiationReading = 0.0f;
        if (tag != null && tag.m_128441_(KEY_LAST_READING)) {
            lastRadiationReading = tag.m_128457_(KEY_LAST_READING);
        }
        if (tag != null && tag.m_128471_(KEY_BROKEN)) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.broken").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.reading").m_130946_(": ").m_7220_(this.getShoddyReadingText(lastRadiationReading)));
        }
    }

    @Override
    protected void addShiftTooltip(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.desc2").m_130940_(ChatFormatting.GRAY));
        float quality = 0.0f;
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(KEY_QUALITY)) {
            quality = stack.m_41783_().m_128457_(KEY_QUALITY);
        }
        tooltip.add(this.getShoddyQualityText(quality));
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_150930_(Items.f_42451_) || pRepairCandidate.m_150930_(Items.f_151041_) || pRepairCandidate.m_204117_(Tags.Items.GLASS) || pRepairCandidate.m_204117_(Tags.Items.INGOTS_COPPER);
    }

    private Component getShoddyReadingText(float radiationLevel) {
        if (radiationLevel <= 0.1f) {
            return Component.m_237115_((String)"tooltip.radioactive.geiger.safe").m_130940_(ChatFormatting.GREEN);
        }
        if (radiationLevel < 5.0f) {
            return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.low").m_130940_(ChatFormatting.YELLOW);
        }
        if (radiationLevel < 20.0f) {
            return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.medium").m_130940_(ChatFormatting.GOLD);
        }
        if (radiationLevel < 40.0f) {
            return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.high").m_130940_(ChatFormatting.RED);
        }
        return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.extreme").m_130940_(ChatFormatting.DARK_RED);
    }

    private Component getShoddyQualityText(float quality) {
        if (quality < 0.2f) {
            return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.very_bad").m_130940_(ChatFormatting.DARK_RED);
        }
        if (quality < 0.5f) {
            return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.bad").m_130940_(ChatFormatting.RED);
        }
        if (quality < 0.8f) {
            return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.poor").m_130940_(ChatFormatting.GOLD);
        }
        return Component.m_237115_((String)"tooltip.radioactive.shoddy_geiger.good").m_130940_(ChatFormatting.GREEN);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand hand) {
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_());
    }
}

