/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.menu;

import com.radar.radioactive.common.blockentities.AbstractPoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class AbstractPoweredMenu
extends AbstractContainerMenu {
    public final AbstractPoweredBlockEntity blockEntity;
    protected final Level level;
    protected final ContainerData data;

    protected AbstractPoweredMenu(MenuType<?> type, int id, Inventory inv, BlockEntity entity, ContainerData data) {
        super(type, id);
        AbstractPoweredMenu.m_38869_((Container)inv, (int)0);
        this.blockEntity = (AbstractPoweredBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.m_38884_(data);
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public int getScaledEnergy() {
        int energyStored = this.data.m_6413_(2);
        int maxEnergy = this.data.m_6413_(3);
        int energyBarSize = 55;
        return maxEnergy != 0 ? (int)((float)energyStored / (float)maxEnergy * (float)energyBarSize) : 0;
    }

    public boolean hasEnoughEnergy() {
        return this.getEnergyStored() > 0;
    }

    public int getRedstoneMode() {
        return this.data.m_6413_(4);
    }

    public boolean isAutoShutOff() {
        return this.data.m_6413_(5) != 0;
    }

    public int getEnergyStored() {
        return this.data.m_6413_(2);
    }

    public int getMaxEnergyStored() {
        return this.data.m_6413_(3);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return AbstractPoweredMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)this.blockEntity.m_58900_().m_60734_());
    }
}

