/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.network.packets;

import com.radar.radioactive.common.blockentities.DecontaminatorBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SSetDeconSizePacket {
    private final BlockPos pos;
    private final int size;

    public C2SSetDeconSizePacket(BlockPos pos, int size) {
        this.pos = pos;
        this.size = size;
    }

    public C2SSetDeconSizePacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.size = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.size);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerLevel level = (ServerLevel)ctx.getSender().m_9236_();
            BlockEntity be = level.m_7702_(this.pos);
            if (be instanceof DecontaminatorBlockEntity) {
                DecontaminatorBlockEntity entity = (DecontaminatorBlockEntity)be;
                entity.setDeconSize(this.size);
            }
        });
        ctx.setPacketHandled(true);
    }
}

