/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.network.packets;

import com.radar.radioactive.client.overlay.GeigerUIRegistry;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2CGeigerUpdatePacket {
    private final boolean active;
    private final float storedRadiation;
    private final float exposureRate;
    private final float effectiveRate;

    public S2CGeigerUpdatePacket(boolean active, float storedRadiation, float exposureRate, float effectiveRate) {
        this.active = active;
        this.storedRadiation = storedRadiation;
        this.exposureRate = exposureRate;
        this.effectiveRate = effectiveRate;
    }

    public static void encode(S2CGeigerUpdatePacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.active);
        buf.writeFloat(packet.storedRadiation);
        buf.writeFloat(packet.exposureRate);
        buf.writeFloat(packet.effectiveRate);
    }

    public static S2CGeigerUpdatePacket decode(FriendlyByteBuf buf) {
        boolean active = buf.readBoolean();
        float storedRadiation = buf.readFloat();
        float exposureRate = buf.readFloat();
        float effectiveRate = buf.readFloat();
        return new S2CGeigerUpdatePacket(active, storedRadiation, exposureRate, effectiveRate);
    }

    public static void handle(S2CGeigerUpdatePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        ctxSupplier.get().enqueueWork(() -> GeigerUIRegistry.updateAll(packet.storedRadiation, packet.exposureRate, packet.effectiveRate));
        ctxSupplier.get().setPacketHandled(true);
    }
}

