/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.network.packets;

import com.radar.radioactive.common.radiation.RadiationRegistry;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class S2CSyncRadiationPacket {
    private final Map<ResourceLocation, Float> radioactiveBlocks;
    private final Map<ResourceLocation, Float> radioactiveBlockTags;
    private final Map<ResourceLocation, Float> radioactiveItems;
    private final Map<ResourceLocation, Float> radioactiveItemTags;
    private final Map<ResourceLocation, Float> reductionArmor;
    private final Map<ResourceLocation, Float> reductionArmorTags;

    public S2CSyncRadiationPacket(Map<ResourceLocation, Float> blocks, Map<ResourceLocation, Float> blockTags, Map<ResourceLocation, Float> items, Map<ResourceLocation, Float> itemTags, Map<ResourceLocation, Float> armor, Map<ResourceLocation, Float> armorTags) {
        this.radioactiveBlocks = blocks;
        this.radioactiveBlockTags = blockTags;
        this.radioactiveItems = items;
        this.radioactiveItemTags = itemTags;
        this.reductionArmor = armor;
        this.reductionArmorTags = armorTags;
    }

    public static void encode(S2CSyncRadiationPacket msg, FriendlyByteBuf buf) {
        buf.m_236831_(msg.radioactiveBlocks, FriendlyByteBuf::m_130085_, FriendlyByteBuf::writeFloat);
        buf.m_236831_(msg.radioactiveBlockTags, FriendlyByteBuf::m_130085_, FriendlyByteBuf::writeFloat);
        buf.m_236831_(msg.radioactiveItems, FriendlyByteBuf::m_130085_, FriendlyByteBuf::writeFloat);
        buf.m_236831_(msg.radioactiveItemTags, FriendlyByteBuf::m_130085_, FriendlyByteBuf::writeFloat);
        buf.m_236831_(msg.reductionArmor, FriendlyByteBuf::m_130085_, FriendlyByteBuf::writeFloat);
        buf.m_236831_(msg.reductionArmorTags, FriendlyByteBuf::m_130085_, FriendlyByteBuf::writeFloat);
    }

    public static S2CSyncRadiationPacket decode(FriendlyByteBuf buf) {
        Map blocks = buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::readFloat);
        Map blockTags = buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::readFloat);
        Map items = buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::readFloat);
        Map itemTags = buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::readFloat);
        Map armor = buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::readFloat);
        Map armorTags = buf.m_236847_(FriendlyByteBuf::m_130281_, FriendlyByteBuf::readFloat);
        return new S2CSyncRadiationPacket(blocks, blockTags, items, itemTags, armor, armorTags);
    }

    public static void handle(S2CSyncRadiationPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> RadiationRegistry.updateClientData(msg.radioactiveBlocks, msg.radioactiveBlockTags, msg.radioactiveItems, msg.radioactiveItemTags, msg.reductionArmor, msg.reductionArmorTags));
        ctx.get().setPacketHandled(true);
    }
}

