/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="radioactive")
public class ArmorUpgradeHandler {
    private static final String RADIATION_REDUCTION_TAG = "radiation_reduction";
    private static final String UPGRADE_TIER_TAG = "upgrade_tier";

    public static void applyUpgrade(ItemStack armor, int tier) {
        CompoundTag nbt = armor.m_41784_();
        int currentTier = ArmorUpgradeHandler.getArmorTier(armor);
        if (tier > currentTier) {
            float reductionToAdd = ArmorUpgradeHandler.getReductionForTier(tier);
            float hadReduction = ArmorUpgradeHandler.getReductionForTier(currentTier);
            float currentReduction = ArmorUpgradeHandler.getArmorReduction(armor);
            float newTotalReduction = currentReduction + reductionToAdd - hadReduction;
            nbt.m_128350_(RADIATION_REDUCTION_TAG, newTotalReduction);
            nbt.m_128405_(UPGRADE_TIER_TAG, tier);
        }
    }

    public static void downgradeArmor(ItemStack armor) {
        CompoundTag nbt = armor.m_41784_();
        if (nbt.m_128451_(UPGRADE_TIER_TAG) <= 1) {
            nbt.m_128473_(RADIATION_REDUCTION_TAG);
            nbt.m_128473_(UPGRADE_TIER_TAG);
        } else {
            int currentTier = nbt.m_128451_(UPGRADE_TIER_TAG);
            float reduction = ArmorUpgradeHandler.getReductionForTier(currentTier - 1);
            nbt.m_128350_(RADIATION_REDUCTION_TAG, reduction);
            nbt.m_128405_(UPGRADE_TIER_TAG, currentTier - 1);
        }
    }

    public static void downgradeArmor(ItemStack armor, int newTier) {
        CompoundTag nbt = armor.m_41784_();
        if (newTier < 1) {
            nbt.m_128473_(RADIATION_REDUCTION_TAG);
            nbt.m_128473_(UPGRADE_TIER_TAG);
        } else {
            float reduction = ArmorUpgradeHandler.getReductionForTier(newTier);
            nbt.m_128350_(RADIATION_REDUCTION_TAG, reduction);
            nbt.m_128405_(UPGRADE_TIER_TAG, newTier);
        }
    }

    public static float getArmorReduction(ItemStack armor) {
        if (!armor.m_41782_()) {
            return 0.0f;
        }
        CompoundTag nbt = armor.m_41783_();
        if (nbt != null && nbt.m_128441_(RADIATION_REDUCTION_TAG)) {
            return nbt.m_128457_(RADIATION_REDUCTION_TAG);
        }
        return 0.0f;
    }

    public static int getArmorTier(ItemStack armor) {
        if (!armor.m_41782_()) {
            return 0;
        }
        CompoundTag nbt = armor.m_41783_();
        if (nbt != null && nbt.m_128441_(UPGRADE_TIER_TAG)) {
            return nbt.m_128451_(UPGRADE_TIER_TAG);
        }
        return 0;
    }

    public static void applyUpgrade(ItemStack armor, float reduction) {
        CompoundTag nbt = armor.m_41784_();
        nbt.m_128350_(RADIATION_REDUCTION_TAG, reduction);
    }

    public static float getReductionForTier(int tier) {
        return switch (tier) {
            case 1 -> {
                if (RadioactiveCommonConfigs.TIER_1_RADIATION_REDUCTION != null) {
                    yield ((Double)RadioactiveCommonConfigs.TIER_1_RADIATION_REDUCTION.get()).floatValue();
                }
                yield 0.12f;
            }
            case 2 -> {
                if (RadioactiveCommonConfigs.TIER_2_RADIATION_REDUCTION != null) {
                    yield ((Double)RadioactiveCommonConfigs.TIER_2_RADIATION_REDUCTION.get()).floatValue();
                }
                yield 0.16f;
            }
            case 3 -> {
                if (RadioactiveCommonConfigs.TIER_3_RADIATION_REDUCTION != null) {
                    yield ((Double)RadioactiveCommonConfigs.TIER_3_RADIATION_REDUCTION.get()).floatValue();
                }
                yield 0.2f;
            }
            default -> 0.0f;
        };
    }
}

