/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation;

import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.spatial.RadiationUpdateService;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class RadiationBlockChangeTracker {
    private RadiationBlockChangeTracker() {
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Level lvl = (Level)event.getLevel();
        if (lvl.f_46443_ || event.isCanceled()) {
            return;
        }
        float rad = RadiationRegistry.getBlockRadiation(ForgeRegistries.BLOCKS.getKey((Object)event.getState().m_60734_()));
        if (rad > 0.0f) {
            RadiationUpdateService.queueAdd((ServerLevel)lvl, event.getPos(), rad);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level lvl = (Level)event.getLevel();
        if (lvl.f_46443_ || event.isCanceled()) {
            return;
        }
        float rad = RadiationRegistry.getBlockRadiation(ForgeRegistries.BLOCKS.getKey((Object)event.getState().m_60734_()));
        if (rad > 0.0f) {
            RadiationUpdateService.queueRemove((ServerLevel)lvl, event.getPos(), rad);
        }
    }

    @SubscribeEvent
    public static void onExplosionEvent(ExplosionEvent event) {
        Level lvl = event.getLevel();
        if (lvl.f_46443_) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        event.getExplosion().m_46081_().forEach(pos -> {
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)lvl.m_8055_(pos).m_60734_());
            float rad = RadiationRegistry.getBlockRadiation(id);
            if (rad > 0.0f) {
                RadiationUpdateService.queueRemove((ServerLevel)lvl, pos, rad);
            }
        });
    }
}

