/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.config.StackingStrategy;
import com.radar.radioactive.common.radiation.ArmorUpgradeHandler;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.capabilities.IRadiationCapability;
import com.radar.radioactive.common.radiation.capabilities.RadiationProvider;
import com.radar.radioactive.common.registries.RadEffects;
import com.radar.radioactive.common.registries.RadEnchantments;
import com.radar.radioactive.common.tags.ModTags;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import top.theillusivec4.curios.api.CuriosApi;

public class RadiationHelper {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public static void setRadiation(LivingEntity entity, float amount) {
        entity.getCapability(RadiationProvider.RADIATION).ifPresent(cap -> cap.setRadiation(amount));
    }

    public static void addRadiation(LivingEntity entity, float amount) {
        entity.getCapability(RadiationProvider.RADIATION).ifPresent(cap -> cap.setRadiation(cap.getRadiation() + amount));
    }

    public static float getRadiation(LivingEntity entity) {
        return entity.getCapability(RadiationProvider.RADIATION).map(IRadiationCapability::getRadiation).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static void setRadiationRate(LivingEntity entity, float amount) {
        entity.getCapability(RadiationProvider.RADIATION).ifPresent(cap -> cap.setExposureRate(amount));
    }

    public static float getRadiationRate(LivingEntity entity) {
        return entity.getCapability(RadiationProvider.RADIATION).map(IRadiationCapability::getExposureRate).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static void setRadiationResistance(LivingEntity entity, float amount) {
        entity.getCapability(RadiationProvider.RADIATION).ifPresent(cap -> cap.setResistance(amount));
    }

    public static float getRadiationResistance(LivingEntity entity) {
        return entity.getCapability(RadiationProvider.RADIATION).map(IRadiationCapability::getResistance).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static void tickRadiationCapability(LivingEntity entity) {
        entity.getCapability(RadiationProvider.RADIATION).ifPresent(IRadiationCapability::tick);
    }

    public static String getRadiationDecayInfo(LivingEntity entity) {
        return entity.getCapability(RadiationProvider.RADIATION).map(cap -> {
            float radiation = cap.getRadiation();
            float exposureRate = cap.getExposureRate();
            float resistance = cap.getResistance();
            float decayMultiplier = RadiationHelper.calculateDecayMultiplier(radiation);
            float baseDecayRate = ((Double)RadioactiveCommonConfigs.RADIATION_DECAY_RATE.get()).floatValue();
            float effectiveDecayRate = baseDecayRate * decayMultiplier;
            return String.format("Radiation: %.1f | Exposure: %.1f/s | Resistance: %.1f%% | Decay: %.1f/s (x%.1f)", Float.valueOf(radiation), Float.valueOf(exposureRate), Float.valueOf(resistance * 100.0f), Float.valueOf(effectiveDecayRate), Float.valueOf(decayMultiplier));
        }).orElse("No radiation capability");
    }

    private static float calculateDecayMultiplier(float currentRadiation) {
        float highThreshold = ((Double)RadioactiveCommonConfigs.DECAY_BOOST_THRESHOLD.get()).floatValue();
        float lowThreshold = ((Double)RadioactiveCommonConfigs.DECAY_REDUCTION_THRESHOLD.get()).floatValue();
        if (currentRadiation >= highThreshold) {
            return ((Double)RadioactiveCommonConfigs.HIGH_RADIATION_DECAY_MULTIPLIER.get()).floatValue();
        }
        if (currentRadiation <= lowThreshold) {
            return ((Double)RadioactiveCommonConfigs.LOW_RADIATION_DECAY_MULTIPLIER.get()).floatValue();
        }
        return 1.0f;
    }

    public static void updateResistance(LivingEntity entity) {
        float totalResistance;
        StackingStrategy strategy;
        ArrayList<Float> reductionSources = new ArrayList<Float>();
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            float armorReduction;
            ItemStack armor = entity.m_6844_(slot);
            if (armor.m_41619_()) continue;
            int level = armor.getEnchantmentLevel((Enchantment)RadEnchantments.ANTI_RADIATION.get());
            if (level > 0) {
                reductionSources.add(Float.valueOf(RadiationHelper.getEnchantmentReduction(level)));
            }
            if (!((armorReduction = RadiationHelper.getItemReduction(armor)) > 0.0f)) continue;
            reductionSources.add(Float.valueOf(armorReduction));
        }
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(inventory -> inventory.getCurios().forEach((slotId, handler) -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                float curioReduction;
                ItemStack stack = handler.getStacks().getStackInSlot(i);
                if (stack.m_41619_() || !((curioReduction = RadiationHelper.getItemReduction(stack)) > 0.0f)) continue;
                reductionSources.add(Float.valueOf(curioReduction));
            }
        }));
        if (entity.m_21023_((MobEffect)RadEffects.RADIATION_RESISTANCE.get())) {
            Optional.ofNullable(entity.m_21124_((MobEffect)RadEffects.RADIATION_RESISTANCE.get())).ifPresent(effect -> {
                int amplifier = effect.m_19564_();
                reductionSources.add(Float.valueOf(0.25f + (float)amplifier * 0.25f));
            });
        }
        if ((strategy = (StackingStrategy)((Object)RadioactiveCommonConfigs.PROTECTION_STACKING_STRATEGY.get())) == StackingStrategy.MULTIPLICATIVE) {
            float remaining = 1.0f;
            var5_9 = reductionSources.iterator();
            while (var5_9.hasNext()) {
                float reduction = ((Float)var5_9.next()).floatValue();
                remaining *= 1.0f - reduction;
            }
            totalResistance = 1.0f - remaining;
        } else {
            float sum = 0.0f;
            var5_9 = reductionSources.iterator();
            while (var5_9.hasNext()) {
                float reduction = ((Float)var5_9.next()).floatValue();
                sum += reduction;
            }
            totalResistance = sum;
        }
        if (entity.m_21023_((MobEffect)RadEffects.TOXIC_PARTICLES.get())) {
            totalResistance -= ((Double)RadioactiveCommonConfigs.FOG_RADIATION_REDUCTION.get()).floatValue();
        }
        totalResistance = Math.min(1.0f, Math.max(0.0f, totalResistance));
        RadiationHelper.setRadiationResistance(entity, totalResistance);
    }

    public static float getItemReduction(ItemStack stack) {
        float Tagreduction = ArmorUpgradeHandler.getArmorReduction(stack);
        float baseReduction = RadiationRegistry.getArmorReduction(stack);
        return Tagreduction + baseReduction;
    }

    public static float getEnchantmentReduction(int level) {
        return (float)level * ((Double)RadioactiveCommonConfigs.ANTI_RAD_REDUCTION_PER_LEVEL.get()).floatValue();
    }

    public static boolean hasGasMask(LivingEntity entity) {
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        return helmet.m_204117_(ModTags.GAS_MASKS);
    }
}

