/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.network.NetworkHandler;
import com.radar.radioactive.common.network.packets.S2CSyncRadiationPacket;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class RadiationRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Float>>(){}.getType();
    private static final Gson GSON_MOB_DESERIALIZER = new GsonBuilder().registerTypeAdapter(MobRadiationData.class, (Object)new MobRadiationData.Deserializer()).create();
    private static final Map<ResourceLocation, Float> radioactiveBlocks = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveItems = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveBiomes = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveDimensions = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, MobRadiationData> radioactiveMobData = new ConcurrentHashMap<ResourceLocation, MobRadiationData>();
    private static final Map<ResourceLocation, Float> radioactiveStructures = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> reductionArmor = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveBlockTags = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveItemTags = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, Float> radioactiveBiomeTags = new ConcurrentHashMap<ResourceLocation, Float>();
    private static final Map<ResourceLocation, MobRadiationData> radioactiveMobTagData = new ConcurrentHashMap<ResourceLocation, MobRadiationData>();
    private static final Map<ResourceLocation, Float> reductionArmorTags = new ConcurrentHashMap<ResourceLocation, Float>();

    public RadiationRegistry() {
        super(GSON, "radioactive");
    }

    public static float getBlockRadiation(ResourceLocation id) {
        if (radioactiveBlocks.containsKey(id)) {
            return radioactiveBlocks.get(id).floatValue();
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
        if (block != null) {
            return RadiationRegistry.getMaxTagRadiation(block.m_204297_().m_203616_(), radioactiveBlockTags);
        }
        return 0.0f;
    }

    public static float getBlockRadiation(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        float blockRadiation = RadiationRegistry.getBlockRadiation(blockId);
        ResourceLocation biomeId = ((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_();
        return blockRadiation += RadiationRegistry.getBiomeRadiation(biomeId);
    }

    public static float getItemRadiation(ResourceLocation id) {
        float itemRadiation;
        if (id == null) {
            Radioactive.LOGGER.warn("Attempted to get radiation for null item ID");
            return 0.0f;
        }
        float directItemRadiation = radioactiveItems.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        float tagRadiation = 0.0f;
        if (item != null) {
            tagRadiation = RadiationRegistry.getMaxTagRadiation(item.m_204114_().m_203616_(), radioactiveItemTags);
        }
        if ((itemRadiation = Math.max(directItemRadiation, tagRadiation)) == 0.0f && item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)blockItem.m_40614_());
            itemRadiation = RadiationRegistry.getBlockRadiation(blockId);
        }
        return itemRadiation;
    }

    public static float getItemRadiation(ItemStack item) {
        return RadiationRegistry.getItemRadiation(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
    }

    public static float getItemStackRadiation(ItemStack stack) {
        return RadiationRegistry.getItemRadiation(stack) * (float)stack.m_41613_();
    }

    public static float getBiomeRadiation(ResourceLocation id) {
        Float directValue = radioactiveBiomes.get(id);
        if (directValue != null) {
            return directValue.floatValue();
        }
        return radioactiveBiomeTags.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public static float getBiomeRadiation(Level level, BlockPos pos) {
        ResourceLocation biomeId = ((ResourceKey)level.m_204166_(pos).m_203543_().get()).m_135782_();
        return RadiationRegistry.getBiomeRadiation(biomeId);
    }

    public static float getMobRadiation(LivingEntity entity) {
        if (entity == null) {
            return 0.0f;
        }
        if (entity.getPersistentData().m_128425_("radioactive:radiation_override", 3)) {
            return entity.getPersistentData().m_128457_("radioactive:radiation_override");
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId == null) {
            return 0.0f;
        }
        AtomicReference<MobRadiationData> data = new AtomicReference<MobRadiationData>(radioactiveMobData.get(entityId));
        if (data.get() == null) {
            entity.m_6095_().getTags().map(tagKey -> radioactiveMobTagData.get(tagKey.f_203868_())).filter(Objects::nonNull).max(Comparator.comparing(MobRadiationData::getBaseRadiation)).ifPresent(data::set);
        }
        float[] totalRadiation = new float[]{0.0f};
        if (data.get() != null) {
            totalRadiation[0] = totalRadiation[0] + data.get().getBaseRadiation();
            entity.m_9236_().m_204166_(entity.m_20183_()).m_203543_().ifPresent(key -> {
                float biomeModifier = ((MobRadiationData)data.get()).getBiomeModifier(key.m_135782_());
                totalRadiation[0] = totalRadiation[0] + biomeModifier;
            });
        }
        if (entity.getPersistentData().m_128425_("radioactive:radiation", 3)) {
            totalRadiation[0] = totalRadiation[0] + entity.getPersistentData().m_128457_("radioactive:radiation");
        }
        return totalRadiation[0];
    }

    public static float getStructureRadiation(ResourceLocation structureId) {
        return radioactiveStructures.getOrDefault(structureId, Float.valueOf(0.0f)).floatValue();
    }

    public static float getDimensionRadiation(ResourceLocation id) {
        return radioactiveDimensions.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public static float getArmorReduction(ResourceLocation id) {
        if (reductionArmor.containsKey(id)) {
            return reductionArmor.get(id).floatValue();
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item != null) {
            return RadiationRegistry.getMaxTagRadiation(item.m_204114_().m_203616_(), reductionArmorTags);
        }
        return 0.0f;
    }

    public static float getArmorReduction(ItemStack item) {
        return RadiationRegistry.getArmorReduction(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
    }

    public static Map<ResourceLocation, Float> getRadioactiveStructures() {
        return radioactiveStructures;
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Radioactive.LOGGER.info("Sending radiation data to player: {}", (Object)player2.m_7755_().getString());
            NetworkHandler.sendToPlayer(new S2CSyncRadiationPacket(radioactiveBlocks, radioactiveBlockTags, radioactiveItems, radioactiveItemTags, reductionArmor, reductionArmorTags), player2);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        StagingData stagingData = new StagingData();
        Radioactive.LOGGER.info("Radiation registry reloading on worker thread...");
        resourceMap.forEach((location, jsonElement) -> {
            try {
                this.processResource((ResourceLocation)location, (JsonElement)jsonElement, stagingData);
            }
            catch (Exception e) {
                Radioactive.LOGGER.error("Error processing resource {}: {}", location, (Object)e.getMessage());
            }
        });
        this.clearAllData();
        radioactiveBlocks.putAll(stagingData.blocks);
        radioactiveBlockTags.putAll(stagingData.blockTags);
        radioactiveItems.putAll(stagingData.items);
        radioactiveItemTags.putAll(stagingData.itemTags);
        radioactiveBiomes.putAll(stagingData.biomes);
        radioactiveBiomeTags.putAll(stagingData.biomeTags);
        radioactiveDimensions.putAll(stagingData.dimensions);
        radioactiveMobData.putAll(stagingData.mobData);
        radioactiveMobTagData.putAll(stagingData.mobTagData);
        radioactiveStructures.putAll(stagingData.structures);
        reductionArmor.putAll(stagingData.armor);
        reductionArmorTags.putAll(stagingData.armorTags);
        this.logLoadedData();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.execute(() -> {
                Radioactive.LOGGER.info("Sending updated radiation data to all clients from main server thread.");
                NetworkHandler.sendToAll(new S2CSyncRadiationPacket(radioactiveBlocks, radioactiveBlockTags, radioactiveItems, radioactiveItemTags, reductionArmor, reductionArmorTags));
            });
        }
    }

    private void clearAllData() {
        radioactiveBlocks.clear();
        radioactiveItems.clear();
        radioactiveBiomes.clear();
        radioactiveDimensions.clear();
        radioactiveMobData.clear();
        radioactiveStructures.clear();
        reductionArmor.clear();
        radioactiveBlockTags.clear();
        radioactiveItemTags.clear();
        radioactiveBiomeTags.clear();
        radioactiveMobTagData.clear();
        reductionArmorTags.clear();
    }

    private void processResource(ResourceLocation location, JsonElement jsonElement, StagingData staging) {
        String path = location.m_135815_();
        Radioactive.LOGGER.debug("Processing resource: {}", (Object)location);
        if (path.startsWith("blocks/")) {
            this.loadData(jsonElement, staging.blocks, staging.blockTags, "block");
        } else if (path.startsWith("items/")) {
            this.loadData(jsonElement, staging.items, staging.itemTags, "item");
        } else if (path.startsWith("biomes/")) {
            this.loadData(jsonElement, staging.biomes, staging.biomeTags, "biome");
        } else if (path.startsWith("dimensions/")) {
            this.loadData(jsonElement, staging.dimensions, "dimension");
        } else if (path.startsWith("mobs/")) {
            this.loadMobData(jsonElement, staging.mobData, staging.mobTagData);
        } else if (path.startsWith("structures/")) {
            this.loadData(jsonElement, staging.structures, "structure");
        } else if (path.startsWith("armor/")) {
            this.loadData(jsonElement, staging.armor, staging.armorTags, "armor");
        }
    }

    private void logLoadedData() {
        Radioactive.LOGGER.info("--- Radiation Registry Loading Complete ---");
        this.logMapData("item", radioactiveItems, radioactiveItemTags);
        this.logMapData("block", radioactiveBlocks, radioactiveBlockTags);
        this.logMapData("biome", radioactiveBiomes, radioactiveBiomeTags);
        this.logMapData("mob", radioactiveMobData, radioactiveMobTagData, true);
        this.logMapData("structure", radioactiveStructures, null);
        this.logMapData("armor reduction", reductionArmor, reductionArmorTags);
        Radioactive.LOGGER.info("-------------------------------------------");
    }

    private void logMapData(String name, Map<ResourceLocation, ?> directMap, Map<ResourceLocation, ?> tagMap) {
        this.logMapData(name, directMap, tagMap, false);
    }

    private void logMapData(String name, Map<ResourceLocation, ?> directMap, Map<ResourceLocation, ?> tagMap, boolean isMobData) {
        if (!directMap.isEmpty() || tagMap != null && !tagMap.isEmpty()) {
            int directSize = directMap.size();
            int tagSize = tagMap != null ? tagMap.size() : 0;
            Radioactive.LOGGER.info("Loaded {} radioactive {} entries ({} direct, {} tags)", (Object)(directSize + tagSize), (Object)name, (Object)directSize, (Object)tagSize);
        }
    }

    private void loadData(JsonElement json, Map<ResourceLocation, Float> directMap, Map<ResourceLocation, Float> tagMap, String dataType) {
        try {
            Map data = (Map)GSON.fromJson(json, MAP_TYPE);
            if (data == null) {
                return;
            }
            data.forEach((key, value) -> {
                if (key.startsWith("#")) {
                    if (tagMap != null) {
                        ResourceLocation id = new ResourceLocation(key.substring(1));
                        tagMap.merge(id, (Float)value, (oldValue, newValue) -> {
                            if (oldValue.equals(newValue)) {
                                return oldValue;
                            }
                            Radioactive.LOGGER.warn("Duplicate radiation tag definition for '{}' in category '{}'. Old: {}, New: {}. Using higher value.", (Object)id, (Object)dataType, oldValue, newValue);
                            return Float.valueOf(Math.max(oldValue.floatValue(), newValue.floatValue()));
                        });
                    } else {
                        Radioactive.LOGGER.warn("Found a tag entry '{}' for data type '{}' which does not support tags. Entry skipped.", key, (Object)dataType);
                    }
                } else {
                    ResourceLocation id = new ResourceLocation(key);
                    directMap.merge(id, (Float)value, (oldValue, newValue) -> {
                        if (oldValue.equals(newValue)) {
                            return oldValue;
                        }
                        Radioactive.LOGGER.warn("Duplicate radiation definition for '{}' in category '{}'. Old: {}, New: {}. Using higher value.", (Object)id, (Object)dataType, oldValue, newValue);
                        return Float.valueOf(Math.max(oldValue.floatValue(), newValue.floatValue()));
                    });
                }
            });
        }
        catch (JsonSyntaxException e) {
            Radioactive.LOGGER.error("Error parsing JSON for {} data: {}", (Object)dataType, (Object)e.getMessage());
        }
    }

    private void loadData(JsonElement json, Map<ResourceLocation, Float> directMap, String dataType) {
        try {
            Map data = (Map)GSON.fromJson(json, MAP_TYPE);
            if (data == null) {
                return;
            }
            data.forEach((key, value) -> {
                ResourceLocation id = new ResourceLocation(key);
                directMap.merge(id, (Float)value, (oldValue, newValue) -> {
                    if (oldValue.equals(newValue)) {
                        return oldValue;
                    }
                    Radioactive.LOGGER.warn("Duplicate radiation definition for '{}' in category '{}'. Old: {}, New: {}. Using higher value.", (Object)id, (Object)dataType, oldValue, newValue);
                    return Float.valueOf(Math.max(oldValue.floatValue(), newValue.floatValue()));
                });
            });
        }
        catch (JsonSyntaxException e) {
            Radioactive.LOGGER.error("Error parsing JSON for {} data: {}", (Object)dataType, (Object)e.getMessage());
        }
    }

    private static <T> float getMaxTagRadiation(Stream<TagKey<T>> tagsStream, Map<ResourceLocation, Float> tagRadiationMap) {
        return (float)tagsStream.map(TagKey::f_203868_).mapToDouble(tagId -> tagRadiationMap.getOrDefault(tagId, Float.valueOf(0.0f)).floatValue()).max().orElse(0.0);
    }

    private void loadMobData(JsonElement json, Map<ResourceLocation, MobRadiationData> directMap, Map<ResourceLocation, MobRadiationData> tagMap) {
        try {
            JsonObject data = json.getAsJsonObject();
            if (data == null) {
                return;
            }
            data.entrySet().forEach(entry -> {
                String key = (String)entry.getKey();
                JsonElement valueJson = (JsonElement)entry.getValue();
                if (!valueJson.isJsonObject()) {
                    Radioactive.LOGGER.warn("Skipping non-object mob radiation entry for key: {}", (Object)key);
                    return;
                }
                MobRadiationData mobData = (MobRadiationData)GSON_MOB_DESERIALIZER.fromJson(valueJson, MobRadiationData.class);
                if (key.startsWith("#")) {
                    ResourceLocation id = new ResourceLocation(key.substring(1));
                    if (radioactiveMobTagData.containsKey(id)) {
                        Radioactive.LOGGER.warn("Duplicate radiation tag definition for mob tag '{}'. Overwriting with data from new file.", (Object)id);
                    }
                    tagMap.put(id, mobData);
                } else {
                    ResourceLocation id = new ResourceLocation(key);
                    if (radioactiveMobData.containsKey(id)) {
                        Radioactive.LOGGER.warn("Duplicate radiation definition for mob '{}'. Overwriting with data from new file.", (Object)id);
                    }
                    directMap.put(id, mobData);
                }
            });
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            Radioactive.LOGGER.error("Error parsing JSON for mob data: {}", (Object)e.getMessage());
        }
    }

    public static void updateClientData(Map<ResourceLocation, Float> blocks, Map<ResourceLocation, Float> blockTags, Map<ResourceLocation, Float> items, Map<ResourceLocation, Float> itemTags, Map<ResourceLocation, Float> armor, Map<ResourceLocation, Float> armorTags) {
        Radioactive.LOGGER.info("Receiving radiation data from server.");
        radioactiveBlocks.clear();
        radioactiveBlocks.putAll(blocks);
        radioactiveBlockTags.clear();
        radioactiveBlockTags.putAll(blockTags);
        radioactiveItems.clear();
        radioactiveItems.putAll(items);
        radioactiveItemTags.clear();
        radioactiveItemTags.putAll(itemTags);
        reductionArmor.clear();
        reductionArmor.putAll(armor);
        reductionArmorTags.clear();
        reductionArmorTags.putAll(armorTags);
    }

    public static class MobRadiationData {
        private final float baseRadiation;
        private final Map<ResourceLocation, Float> biomeModifiers;

        public MobRadiationData(float baseRadiation, Map<ResourceLocation, Float> biomeModifiers) {
            this.baseRadiation = baseRadiation;
            this.biomeModifiers = biomeModifiers != null ? Collections.unmodifiableMap(new HashMap<ResourceLocation, Float>(biomeModifiers)) : Collections.emptyMap();
        }

        public float getBaseRadiation() {
            return this.baseRadiation;
        }

        public float getBiomeModifier(ResourceLocation biomeId) {
            return this.biomeModifiers.getOrDefault(biomeId, Float.valueOf(0.0f)).floatValue();
        }

        public static class Deserializer
        implements JsonDeserializer<MobRadiationData> {
            public MobRadiationData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (!json.isJsonObject()) {
                    throw new JsonParseException("Expected a JSON object for MobRadiationData");
                }
                JsonObject obj = json.getAsJsonObject();
                float base = obj.has("base") ? obj.get("base").getAsFloat() : 0.0f;
                HashMap<ResourceLocation, Float> biomeModifiers = new HashMap<ResourceLocation, Float>();
                if (obj.has("biomes")) {
                    JsonElement biomesElement = obj.get("biomes");
                    if (biomesElement.isJsonObject()) {
                        JsonObject biomesObj = biomesElement.getAsJsonObject();
                        for (Map.Entry entry : biomesObj.entrySet()) {
                            try {
                                biomeModifiers.put(new ResourceLocation((String)entry.getKey()), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
                            }
                            catch (Exception e) {
                                throw new JsonParseException("Invalid biome entry: " + (String)entry.getKey(), (Throwable)e);
                            }
                        }
                    } else {
                        throw new JsonParseException("'biomes' field must be an object.");
                    }
                }
                return new MobRadiationData(base, biomeModifiers);
            }
        }
    }

    private static class StagingData {
        final Map<ResourceLocation, Float> blocks = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> blockTags = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> items = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> itemTags = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> biomes = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> biomeTags = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> dimensions = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, MobRadiationData> mobData = new HashMap<ResourceLocation, MobRadiationData>();
        final Map<ResourceLocation, MobRadiationData> mobTagData = new HashMap<ResourceLocation, MobRadiationData>();
        final Map<ResourceLocation, Float> structures = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> armor = new HashMap<ResourceLocation, Float>();
        final Map<ResourceLocation, Float> armorTags = new HashMap<ResourceLocation, Float>();

        private StagingData() {
        }
    }
}

