/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation;

import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.geometry.Geometry;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.capabilities.RadiationCapabilities;
import com.radar.radioactive.common.radiation.spatial.Attenuation;
import com.radar.radioactive.common.radiation.spatial.RadiationIndex;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StochasticRadiationValidator {
    private static final Random RANDOM = new Random();
    private static final int CHUNKS_TO_VALIDATE_PER_CYCLE = 2;

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase != TickEvent.Phase.END || event.level.m_5776_() || !((level = event.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (event.level.m_46467_() % 100L != 0L) {
            return;
        }
        Set playerChunkPositions = level2.m_6907_().stream().map(Entity::m_146902_).collect(Collectors.toSet());
        if (playerChunkPositions.isEmpty()) {
            return;
        }
        ArrayList chunkList = new ArrayList(playerChunkPositions);
        Collections.shuffle(chunkList, RANDOM);
        int validationCount = Math.min(2, chunkList.size());
        for (int i = 0; i < validationCount; ++i) {
            ChunkPos posToValidate = (ChunkPos)chunkList.get(i);
            LevelChunk chunk = level2.m_6325_(posToValidate.f_45578_, posToValidate.f_45579_);
            StochasticRadiationValidator.validateChunk(chunk, level2);
        }
    }

    private static void validateChunk(LevelChunk chunk, ServerLevel level) {
        chunk.getCapability(RadiationCapabilities.CHUNK_RADIATION).ifPresent(cap -> {
            RadiationIndex localIndex = cap.getIndex();
            if (localIndex.size() == 0) {
                return;
            }
            ArrayList<Entry<RadiationSource, Geometry>> ghosts = new ArrayList<Entry<RadiationSource, Geometry>>();
            for (Entry<RadiationSource, Geometry> entry : localIndex.entries()) {
                BlockPos pos;
                float currentRadiation;
                RadiationSource source = entry.value();
                if (source.law() != Attenuation.FAST_INV_SQ || !((currentRadiation = RadiationRegistry.getBlockRadiation(ForgeRegistries.BLOCKS.getKey((Object)level.m_8055_(pos = new BlockPos((int)source.bounds().mins()[0], (int)source.bounds().mins()[1], (int)source.bounds().mins()[2])).m_60734_()))) <= 0.0f)) continue;
                ghosts.add(entry);
            }
            if (!ghosts.isEmpty()) {
                Radioactive.LOGGER.debug("Validator removed {} ghost sources from player-occupied chunk {}.", (Object)ghosts.size(), (Object)chunk.m_7697_());
                localIndex.removeEntries(ghosts);
                chunk.m_8092_(true);
            }
        });
    }
}

