/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.capabilities;

import com.radar.radioactive.common.radiation.spatial.ChunkRadiation;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationCapabilities {
    public static final Capability<ChunkRadiation> CHUNK_RADIATION = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkRadiation>(){});
    public static final ResourceLocation ID = new ResourceLocation("radioactive", "chunk_radiation");

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        Provider provider = new Provider(new ChunkRadiation());
        event.addCapability(ID, (ICapabilityProvider)provider);
        event.addListener(() -> provider.optional.invalidate());
    }

    private static class Provider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final ChunkRadiation instance;
        private final LazyOptional<ChunkRadiation> optional;

        public Provider(ChunkRadiation instance) {
            this.instance = instance;
            this.optional = LazyOptional.of(() -> this.instance);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == CHUNK_RADIATION ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT(nbt);
        }
    }
}

