/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.capabilities;

import com.radar.radioactive.common.radiation.capabilities.IRadiationCapability;
import com.radar.radioactive.common.radiation.capabilities.PlayerRadiation;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<IRadiationCapability> RADIATION = CapabilityManager.get((CapabilityToken)new CapabilityToken<IRadiationCapability>(){});
    private final PlayerRadiation radiation = new PlayerRadiation();
    private final LazyOptional<IRadiationCapability> optional = LazyOptional.of(() -> this.radiation);

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("radioactive", "radiation_cap"), (ICapabilityProvider)new RadiationProvider());
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return RADIATION.orEmpty(cap, this.optional);
    }

    public CompoundTag serializeNBT() {
        return this.radiation.serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.radiation.deserializeNBT(nbt);
    }
}

