/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.level;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.radiation.level.RadiationDamage;
import com.radar.radioactive.common.radiation.level.RadiationLevel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationLevelRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(RadiationDamage.class, (Object)new RadiationDamage.Deserializer()).create();
    private static final Map<ResourceLocation, RadiationLevel> radiationLevels = new ConcurrentHashMap<ResourceLocation, RadiationLevel>();
    private static List<RadiationLevel> sortedRadiationLevels = new ArrayList<RadiationLevel>();

    public RadiationLevelRegistry() {
        super(GSON, "radioactive/levels");
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RadiationLevelRegistry());
    }

    protected void apply(Map<ResourceLocation, JsonElement> resourceMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        radiationLevels.clear();
        Radioactive.LOGGER.debug("Reloading radiation levels from 'radioactive/levels'...");
        resourceMap.forEach((location, jsonElement) -> {
            try {
                RadiationLevel radiationLevel = (RadiationLevel)GSON.fromJson(jsonElement, RadiationLevel.class);
                radiationLevel.setId((ResourceLocation)location);
                radiationLevels.put((ResourceLocation)location, radiationLevel);
                Radioactive.LOGGER.debug("Loaded radiation level: {}", location);
            }
            catch (Exception e) {
                Radioactive.LOGGER.error("Error loading radiation level from {}: {}", location, (Object)e.getMessage());
            }
        });
        sortedRadiationLevels = radiationLevels.values().stream().sorted(Comparator.comparingInt(RadiationLevel::getRadiationThreshold)).collect(Collectors.toList());
        Radioactive.LOGGER.info("Successfully loaded {} radiation levels.", (Object)radiationLevels.size());
    }

    @Nullable
    public static RadiationLevel getRadiationLevel(int radiation) {
        RadiationLevel applicableLevel = null;
        for (RadiationLevel level : sortedRadiationLevels) {
            if (radiation < level.getRadiationThreshold()) break;
            applicableLevel = level;
        }
        return applicableLevel;
    }

    @Nullable
    public static RadiationLevel getRadiationLevel(ResourceLocation id) {
        return radiationLevels.get(id);
    }

    public static Map<ResourceLocation, RadiationLevel> getLevels() {
        return radiationLevels;
    }

    public static List<RadiationLevel> getSortedLevels() {
        return sortedRadiationLevels;
    }
}

