/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.sources;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.sources.IAsyncRadiationSourceProvider;
import com.radar.radioactive.common.radiation.spatial.RadiationRaycast;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistryAPI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class ContainerRadiationProvider
implements IAsyncRadiationSourceProvider {
    @Override
    public CompletableFuture<Float> getRadiationAsync(Player p) {
        if (SafeChunkRegistryAPI.isSafe(p.m_9236_(), p.m_146902_())) {
            return CompletableFuture.completedFuture(Float.valueOf(0.0f));
        }
        Level level = p.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return CompletableFuture.completedFuture(Float.valueOf(0.0f));
        }
        ServerLevel level2 = (ServerLevel)level;
        float blockRadius = ((Double)RadioactiveCommonConfigs.ENVIRONMENTAL_SCAN_RADIUS.get()).floatValue();
        int chunkRadius = (Integer)RadioactiveCommonConfigs.PLAYER_SCAN_RADIUS_CHUNKS.get();
        float sum = 0.0f;
        ArrayList<CompletionStage> tasks = new ArrayList<CompletionStage>();
        ChunkPos playerChunkPos = p.m_146902_();
        for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
            for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
                ChunkPos pos = new ChunkPos(playerChunkPos.f_45578_ + dx, playerChunkPos.f_45579_ + dz);
                LevelChunk chunk = level2.m_7726_().m_7131_(pos.f_45578_, pos.f_45579_);
                if (chunk == null) continue;
                for (Map.Entry entry : chunk.m_62954_().entrySet()) {
                    float containerRad;
                    double dzW;
                    double dyW;
                    BlockPos bePos = (BlockPos)entry.getKey();
                    double dxW = (double)bePos.m_123341_() + 0.5 - p.m_20185_();
                    if (dxW * dxW + (dyW = (double)bePos.m_123342_() + 0.5 - p.m_20186_()) * dyW + (dzW = (double)bePos.m_123343_() + 0.5 - p.m_20189_()) * dzW > (double)(blockRadius * blockRadius) || (containerRad = ContainerRadiationProvider.calculateContainerRadiation((BlockEntity)entry.getValue())) <= 0.0f) continue;
                    RadiationSource source = RadiationSource.block(bePos, containerRad);
                    float base = source.contribution(p.m_20182_());
                    CompletionStage f = RadiationRaycast.calculateExposureAsync(source, p.m_20182_(), p.m_20183_(), level2).thenApply(exposure -> Float.valueOf(base * exposure.floatValue()));
                    tasks.add(f);
                }
            }
        }
        return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(v -> {
            float total = 0.0f;
            for (CompletableFuture f : tasks) {
                total += f.getNow(Float.valueOf(0.0f)).floatValue();
            }
            return Float.valueOf(total);
        });
    }

    private static float calculateContainerRadiation(BlockEntity be) {
        IItemHandler handler = (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        float rad = 0.0f;
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                rad += RadiationRegistry.getItemRadiation(stack) * (float)stack.m_41613_();
            }
            return rad;
        }
        if (be instanceof Container) {
            Container cont = (Container)be;
            for (int i = 0; i < cont.m_6643_(); ++i) {
                ItemStack stack = cont.m_8020_(i);
                if (stack.m_41619_()) continue;
                rad += RadiationRegistry.getItemRadiation(stack) * (float)stack.m_41613_();
            }
        }
        return rad;
    }
}

