/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.sources;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.radiation.sources.IRadiationSourceProvider;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistryAPI;
import com.radar.radioactive.common.registries.RadEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class MiscRadiationProvider
implements IRadiationSourceProvider {
    @Override
    public float getRadiation(Player p) {
        if (SafeChunkRegistryAPI.isSafe(p.m_9236_(), p.m_146902_())) {
            return 0.0f;
        }
        return this.distanceRadiation(p) + this.sunRadiation(p) + this.fogRadiation(p);
    }

    private float distanceRadiation(Player p) {
        double threshold;
        double d = Math.hypot(p.m_20185_(), p.m_20189_());
        if (d <= (threshold = ((Double)RadioactiveCommonConfigs.DISTANCE_RADIATION_THRESHOLD.get()).doubleValue())) {
            return 0.0f;
        }
        float perBlock = ((Double)RadioactiveCommonConfigs.RADIATION_PER_BLOCK_DISTANCE.get()).floatValue();
        return (float)(d - threshold) * perBlock;
    }

    private float sunRadiation(Player p) {
        if (!((Boolean)RadioactiveCommonConfigs.SUN_RADIATION.get()).booleanValue()) {
            return 0.0f;
        }
        if (!p.m_9236_().m_46461_() || !p.m_9236_().m_45527_(p.m_20183_())) {
            return 0.0f;
        }
        long t = p.m_9236_().m_46468_() % 24000L;
        float sunFactor = t < 12000L ? 1.0f - (float)Math.abs(t - 6000L) / 6000.0f : 0.0f;
        return ((Double)RadioactiveCommonConfigs.SUN_RADIATION_PEAK_RATE.get()).floatValue() * sunFactor;
    }

    private float fogRadiation(Player p) {
        return p.m_21023_((MobEffect)RadEffects.TOXIC_PARTICLES.get()) ? ((Double)RadioactiveCommonConfigs.FOG_RADIATION_AMOUNT.get()).floatValue() : 0.0f;
    }
}

