/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.sources;

import com.radar.radioactive.common.config.RadioactiveCommonConfigs;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.sources.IRadiationSourceProvider;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistryAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureRadiationProvider
implements IRadiationSourceProvider {
    @Override
    public float getRadiation(Player p) {
        if (SafeChunkRegistryAPI.isSafe(p.m_9236_(), p.m_146902_())) {
            return 0.0f;
        }
        return this.calculateStructureRadiation((ServerLevel)p.m_9236_(), p.m_20183_());
    }

    private float calculateStructureRadiation(ServerLevel level, BlockPos pos) {
        StructureManager sm = level.m_215010_();
        Registry reg = level.m_9598_().m_175515_(Registries.f_256944_);
        float structure = 0.0f;
        for (ResourceLocation structId : RadiationRegistry.getRadioactiveStructures().keySet()) {
            StructureStart start;
            Structure struct = (Structure)reg.m_7745_(structId);
            if (struct == null || !(start = sm.m_220494_(pos, struct)).m_73603_()) continue;
            float structRad = RadiationRegistry.getStructureRadiation(structId);
            if (((Boolean)RadioactiveCommonConfigs.STACK_STRUCTURE_RADIATION.get()).booleanValue()) {
                structure += structRad;
                continue;
            }
            structure = Math.max(structure, structRad);
        }
        return structure;
    }
}

