/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Attenuation {
    CONSTANT{

        @Override
        public float apply(float s, double d) {
            return s;
        }
    }
    ,
    LINEAR{

        @Override
        public float apply(float s, double d) {
            return (float)Math.max(0.0, (double)s - d);
        }
    }
    ,
    INV_SQ{

        @Override
        public float apply(float s, double d) {
            return d == 0.0 ? s : (float)Math.min((double)s, (double)s / (d * d));
        }
    }
    ,
    FAST_INV_SQ{

        @Override
        public float apply(float s, double d) {
            if (d == 0.0) {
                return s;
            }
            float x = (float)d;
            float invSqrt = 4.fastInverseSqrt(x * x);
            float result = s * invSqrt * invSqrt;
            return Math.min(s, result);
        }
    }
    ,
    HALF_LIFE(16.0f){

        @Override
        public float apply(float s, double d) {
            return (float)Math.min((double)s, (double)s * Math.pow(0.5, d / (double)this.halfRange));
        }
    };

    protected final float halfRange;

    private Attenuation() {
        this.halfRange = 1.0f;
    }

    private Attenuation(float halfRange) {
        this.halfRange = halfRange;
    }

    public abstract float apply(float var1, double var2);

    protected static float fastInverseSqrt(float x) {
        float threehalfs = 1.5f;
        float x2 = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - x2 * x * x;
        return x;
    }
}

