/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.davidmoten.rtree.Entry;
import com.davidmoten.rtree.RTree;
import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.Rectangle;
import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.spatial.Attenuation;
import com.radar.radioactive.common.radiation.spatial.RadiationRaycast;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistry;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public final class RadiationIndex {
    private final AtomicReference<RTree<RadiationSource, Geometry>> ref = new AtomicReference(RTree.dimensions(3).create());
    private final SafeChunkRegistry safe = new SafeChunkRegistry();

    public void add(RadiationSource src) {
        this.ref.updateAndGet(t -> t.add(src, src.bounds()));
    }

    public void remove(RadiationSource src) {
        this.ref.updateAndGet(t -> t.delete(src, src.bounds()));
    }

    public void removeInChunk(ChunkPos pos, ServerLevel level) {
        Rectangle chunkBox = Rectangle.create(pos.m_45604_(), level.m_141937_(), pos.m_45605_(), pos.m_45608_() + 1, level.m_151558_(), pos.m_45609_() + 1);
        RTree<RadiationSource, Geometry> tree = this.ref.get();
        Iterable<Entry<RadiationSource, Geometry>> searchResult = tree.search(chunkBox);
        ArrayList<Entry<RadiationSource, Geometry>> toRemove = new ArrayList<Entry<RadiationSource, Geometry>>();
        for (Entry<RadiationSource, Geometry> entry : searchResult) {
            if (entry.value().law() != Attenuation.FAST_INV_SQ) continue;
            toRemove.add(entry);
        }
        if (!toRemove.isEmpty()) {
            this.removeEntries(toRemove);
        }
    }

    public void removeEntries(Iterable<Entry<RadiationSource, Geometry>> entries) {
        this.ref.updateAndGet(t -> t.delete(entries));
    }

    public Iterable<Entry<RadiationSource, Geometry>> entries() {
        return this.ref.get().entries();
    }

    public float flux(Vec3 pos, float radius, @Nullable Player player, ServerLevel level) {
        Rectangle window = Rectangle.create(pos.f_82479_ - (double)radius, pos.f_82480_ - (double)radius, pos.f_82481_ - (double)radius, pos.f_82479_ + (double)radius, pos.f_82480_ + (double)radius, pos.f_82481_ + (double)radius);
        float sum = 0.0f;
        ArrayList<Entry<RadiationSource, Geometry>> ghostEntries = new ArrayList<Entry<RadiationSource, Geometry>>();
        ArrayList<Entry<RadiationSource, Geometry>> correctionRemovals = new ArrayList<Entry<RadiationSource, Geometry>>();
        ArrayList<RadiationSource> correctionAdditions = new ArrayList<RadiationSource>();
        for (Entry<RadiationSource, Geometry> e : this.ref.get().search(window)) {
            float exposureFactor;
            Rectangle bounds;
            BlockPos blockPos;
            RadiationSource source = e.value();
            boolean isGhost = false;
            if (source.law() == Attenuation.FAST_INV_SQ && level.m_46749_(blockPos = new BlockPos((int)(bounds = source.bounds()).mins()[0], (int)bounds.mins()[1], (int)bounds.mins()[2]))) {
                float blockRadiation = RadiationRegistry.getBlockRadiation(ForgeRegistries.BLOCKS.getKey((Object)level.m_8055_(blockPos).m_60734_()));
                if (blockRadiation <= 0.0f) {
                    ghostEntries.add(e);
                    isGhost = true;
                } else {
                    boolean invalid;
                    float current = source.strength();
                    boolean bl = invalid = Float.isNaN(current) || Float.isInfinite(current) || current < 0.0f;
                    if (invalid || Math.abs(current - blockRadiation) > 1.0E-4f) {
                        RadiationSource corrected = new RadiationSource(Math.max(0.0f, blockRadiation), source.law(), source.bounds());
                        correctionRemovals.add(e);
                        correctionAdditions.add(corrected);
                    }
                }
            }
            if (isGhost) continue;
            float baseContribution = source.contribution(pos);
            if (player != null) {
                exposureFactor = RadiationRaycast.calculateExposure(source, player, level);
            } else {
                BlockPos targetBlockPos = BlockPos.m_274446_((Position)pos);
                exposureFactor = RadiationRaycast.calculateExposure(source, pos, targetBlockPos, level);
            }
            sum += baseContribution * exposureFactor;
        }
        if (!ghostEntries.isEmpty()) {
            Radioactive.LOGGER.debug("Removing {} ghost radiation sources during flux calculation.", (Object)ghostEntries.size());
            this.removeEntries(ghostEntries);
        }
        if (!correctionRemovals.isEmpty()) {
            Radioactive.LOGGER.debug("Correcting {} radiation sources with stale/invalid values.", (Object)correctionRemovals.size());
            this.removeEntries(correctionRemovals);
            for (RadiationSource rs : correctionAdditions) {
                this.add(rs);
            }
        }
        return sum;
    }

    public SafeChunkRegistry safe() {
        return this.safe;
    }

    public int size() {
        return this.ref.get().size();
    }
}

