/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.radar.radioactive.common.Radioactive;
import com.radar.radioactive.common.radiation.spatial.GlobalRadiationWorldData;
import com.radar.radioactive.common.radiation.spatial.RadiationIndex;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="radioactive")
public final class RadiationIndexAPI {
    private static final ConcurrentHashMap<ServerLevel, RadiationIndex> MAP = new ConcurrentHashMap();

    private RadiationIndexAPI() {
    }

    public static RadiationIndex of(ServerLevel level) {
        return MAP.computeIfAbsent(level, l -> {
            GlobalRadiationWorldData data = GlobalRadiationWorldData.get((Level)l);
            return data.getIndex();
        });
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)levelAccessor;
            GlobalRadiationWorldData data = GlobalRadiationWorldData.get((Level)sl);
            MAP.put(sl, data.getIndex());
            Radioactive.LOGGER.debug("Loaded radiation sources from saved data for {}", (Object)sl.m_46472_().m_135782_());
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)levelAccessor;
            MAP.remove(sl);
        }
    }

    public static void remove(ServerLevel level) {
        MAP.remove(level);
    }
}

