/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.davidmoten.rtree.geometry.Geometry;
import com.davidmoten.rtree.geometry.Rectangle;
import com.radar.radioactive.common.radiation.spatial.Attenuation;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public record RadiationSource(float strength, Attenuation law, Rectangle bounds) implements Geometry
{
    public static RadiationSource block(BlockPos p, float strength) {
        Rectangle b = Rectangle.create(p.m_123341_(), p.m_123342_(), p.m_123343_(), p.m_123341_() + 1, p.m_123342_() + 1, p.m_123343_() + 1);
        return new RadiationSource(strength, Attenuation.FAST_INV_SQ, b);
    }

    public static RadiationSource structure(ChunkPos c, float strength) {
        Rectangle b = Rectangle.create(c.m_45604_(), 0.0, c.m_45605_(), c.m_45608_() + 1, 256.0, c.m_45609_() + 1);
        return new RadiationSource(strength, Attenuation.CONSTANT, b);
    }

    public static RadiationSource dynamicChunk(ChunkPos c, float strength) {
        Rectangle b = Rectangle.create(c.m_45604_(), 0.0, c.m_45605_(), c.m_45608_() + 1, 256.0, c.m_45609_() + 1);
        return new RadiationSource(strength, Attenuation.CONSTANT, b);
    }

    public float contribution(Vec3 pos) {
        double dy;
        double dx;
        double[] mins = this.bounds.mins();
        double[] maxes = this.bounds.maxes();
        double d = pos.f_82479_ < mins[0] ? mins[0] - pos.f_82479_ : (dx = pos.f_82479_ > maxes[0] ? pos.f_82479_ - maxes[0] : 0.0);
        double d2 = pos.f_82480_ < mins[1] ? mins[1] - pos.f_82480_ : (dy = pos.f_82480_ > maxes[1] ? pos.f_82480_ - maxes[1] : 0.0);
        double dz = pos.f_82481_ < mins[2] ? mins[2] - pos.f_82481_ : (pos.f_82481_ > maxes[2] ? pos.f_82481_ - maxes[2] : 0.0);
        double d3 = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return this.law.apply(this.strength, d3);
    }

    @Override
    public Rectangle mbr() {
        return this.bounds;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.bounds.intersects(r);
    }

    @Override
    public double distance(Rectangle r) {
        return this.bounds.distance(r);
    }

    @Override
    public int dimensions() {
        return 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof RadiationSource)) return false;
        RadiationSource rs = (RadiationSource)o;
        if (Float.compare(rs.strength, this.strength) != 0) return false;
        if (this.law != rs.law) return false;
        if (!this.bounds.equals(rs.bounds)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{Float.valueOf(this.strength), this.law, this.bounds});
    }
}

