/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.radar.radioactive.common.radiation.spatial.GlobalRadiationIndexAPI;
import com.radar.radioactive.common.radiation.spatial.SafeChunkRegistry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public final class SafeChunkRegistryAPI {
    private SafeChunkRegistryAPI() {
    }

    public static boolean isSafe(Level lvl, ChunkPos cp) {
        if (!(lvl instanceof ServerLevel)) {
            return false;
        }
        ServerLevel sl = (ServerLevel)lvl;
        return GlobalRadiationIndexAPI.of(sl).safe().isSafe(cp);
    }

    public static void modifyRange(Level lvl, ChunkPos centre, int range, boolean safe) {
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)lvl;
        SafeChunkRegistry reg = GlobalRadiationIndexAPI.of(sl).safe();
        for (int dx = -range; dx <= range; ++dx) {
            for (int dz = -range; dz <= range; ++dz) {
                ChunkPos cp = new ChunkPos(centre.f_45578_ + dx, centre.f_45579_ + dz);
                if (safe) {
                    reg.markSafe(cp);
                    continue;
                }
                reg.markUnsafe(cp);
            }
        }
    }
}

