/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.radiation.spatial;

import com.radar.radioactive.common.radiation.RadiationRegistry;
import com.radar.radioactive.common.radiation.capabilities.RadiationCapabilities;
import com.radar.radioactive.common.radiation.spatial.RadiationIndex;
import com.radar.radioactive.common.radiation.spatial.RadiationSource;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.event.level.ChunkDataEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="radioactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class WorldGenScanner {
    private static final String SCANNED_NBT_KEY = "RadioactiveScanned";
    private static final Set<ChunkPos> SCANNED_CHUNKS = Collections.newSetFromMap(new ConcurrentHashMap());

    private WorldGenScanner() {
    }

    @SubscribeEvent
    public static void onChunkDataLoad(ChunkDataEvent.Load e) {
        if (e.getData().m_128471_(SCANNED_NBT_KEY)) {
            SCANNED_CHUNKS.add(e.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkDataSave(ChunkDataEvent.Save e) {
        if (SCANNED_CHUNKS.contains(e.getChunk().m_7697_())) {
            e.getData().m_128379_(SCANNED_NBT_KEY, true);
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load e) {
        ServerLevel sl;
        block5: {
            block4: {
                LevelAccessor levelAccessor = e.getLevel();
                if (!(levelAccessor instanceof ServerLevel)) break block4;
                sl = (ServerLevel)levelAccessor;
                if (!e.isCanceled()) break block5;
            }
            return;
        }
        ChunkAccess chunk = e.getChunk();
        if (SCANNED_CHUNKS.add(chunk.m_7697_())) {
            WorldGenScanner.scanChunkForBlocks(sl, chunk);
        }
    }

    private static void scanChunkForBlocks(ServerLevel sl, ChunkAccess ch) {
        if (!(ch instanceof LevelChunk)) {
            return;
        }
        LevelChunk levelChunk = (LevelChunk)ch;
        levelChunk.getCapability(RadiationCapabilities.CHUNK_RADIATION).ifPresent(cap -> {
            RadiationIndex localIndex = cap.getIndex();
            boolean sourcesFound = false;
            for (int sectionIdx = sl.m_151560_(); sectionIdx < sl.m_151561_(); ++sectionIdx) {
                LevelChunkSection section = levelChunk.m_183278_(sectionIdx - levelChunk.m_151560_());
                if (section == null || section.m_188008_()) continue;
                int baseY = sectionIdx * 16;
                int baseX = levelChunk.m_7697_().m_45604_();
                int baseZ = levelChunk.m_7697_().m_45605_();
                for (int lx = 0; lx < 16; ++lx) {
                    for (int ly = 0; ly < 16; ++ly) {
                        for (int lz = 0; lz < 16; ++lz) {
                            float rad;
                            BlockState state = section.m_62982_(lx, ly, lz);
                            if (state.m_60795_() || !((rad = RadiationRegistry.getBlockRadiation(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()))) > 0.0f)) continue;
                            BlockPos wp = new BlockPos(baseX + lx, baseY + ly, baseZ + lz);
                            localIndex.add(RadiationSource.block(wp, rad));
                            sourcesFound = true;
                        }
                    }
                }
            }
            if (sourcesFound) {
                levelChunk.m_8092_(true);
            }
        });
    }
}

