/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.radar.radioactive.common.registries.RadRecipeSerializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class NBTAdjustingShapelessRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final Ingredient repairTarget;
    private final int repairAmount;
    private final float increaseAmount;

    public NBTAdjustingShapelessRecipe(ResourceLocation id, ItemStack result, NonNullList<Ingredient> ingredients, Ingredient repairTarget, int repairAmount, float increaseAmount) {
        this.id = id;
        this.result = result;
        this.ingredients = ingredients;
        this.repairTarget = repairTarget;
        this.repairAmount = repairAmount;
        this.increaseAmount = increaseAmount;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList fullList = NonNullList.m_122779_();
        fullList.add((Object)this.repairTarget);
        fullList.addAll(this.ingredients);
        return fullList;
    }

    public boolean matches(CraftingContainer container, Level level) {
        ArrayList<Ingredient> fullIngredients = new ArrayList<Ingredient>();
        fullIngredients.add(this.repairTarget);
        fullIngredients.addAll((Collection<Ingredient>)this.ingredients);
        ArrayList remaining = new ArrayList(fullIngredients);
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            boolean matched = false;
            Iterator iterator = remaining.iterator();
            while (iterator.hasNext()) {
                Ingredient ingredient = (Ingredient)iterator.next();
                if (!ingredient.test(stack)) continue;
                iterator.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return remaining.isEmpty();
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack targetStack = IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)container).m_8020_(arg_0)).filter(stack -> !stack.m_41619_() && this.repairTarget.test(stack)).findFirst().map(ItemStack::m_41777_).orElse(ItemStack.f_41583_);
        if (targetStack.m_41619_()) {
            return this.result.m_41777_();
        }
        int currentDamage = targetStack.m_41773_();
        int newDamage = Math.max(0, currentDamage - this.repairAmount);
        targetStack.m_41721_(newDamage);
        CompoundTag tag = targetStack.m_41784_();
        String qualityKey = "quality";
        float currentQuality = tag.m_128457_(qualityKey);
        float newQuality = currentQuality + this.increaseAmount;
        tag.m_128350_(qualityKey, newQuality);
        return targetStack;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size() + 1;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RadRecipeSerializers.NBT_ADJUSTING_SHAPELESS.get();
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<NBTAdjustingShapelessRecipe> {
        public NBTAdjustingShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList<Ingredient> ingredients = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            Ingredient repairTarget = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"repair_target"));
            float increaseAmount = GsonHelper.m_13915_((JsonObject)json, (String)"quality_increase");
            int repairAmount = GsonHelper.m_13927_((JsonObject)json, (String)"damage");
            return new NBTAdjustingShapelessRecipe(recipeId, result, ingredients, repairTarget, repairAmount, increaseAmount);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray array) {
            NonNullList list = NonNullList.m_122779_();
            for (int i = 0; i < array.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)array.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                list.add((Object)ingredient);
            }
            return list;
        }

        public NBTAdjustingShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            Ingredient repairTarget = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int repairAmount = buffer.m_130242_();
            float increaseAmount = buffer.readFloat();
            return new NBTAdjustingShapelessRecipe(recipeId, result, (NonNullList<Ingredient>)ingredients, repairTarget, repairAmount, increaseAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, NBTAdjustingShapelessRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            recipe.repairTarget.m_43923_(buffer);
            buffer.m_130130_(recipe.repairAmount);
            buffer.writeFloat(recipe.increaseAmount);
        }
    }
}

