/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class DamagedItemIngredient
extends Ingredient {
    public static final ResourceLocation NAME = new ResourceLocation("radioactive", "damaged_item");
    private final Ingredient base;
    private final int minDamage;
    private ItemStack[] matchingStacks;

    public DamagedItemIngredient(Ingredient base, int minDamage) {
        super(Stream.empty());
        this.base = base;
        this.minDamage = minDamage;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public int getMinDamage() {
        return this.minDamage;
    }

    public ItemStack[] m_43908_() {
        if (this.matchingStacks == null) {
            this.matchingStacks = (ItemStack[])Arrays.stream(this.base.m_43908_()).filter(ItemStack::m_41763_).map(stack -> {
                ItemStack damagedStack = stack.m_41777_();
                int maxDamage = damagedStack.m_41776_();
                int displayDamage = Math.min(Math.max(this.minDamage, 0), maxDamage - 1);
                damagedStack.m_41721_(displayDamage);
                return damagedStack;
            }).toArray(ItemStack[]::new);
        }
        return this.matchingStacks;
    }

    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        if (!itemStack.m_41763_()) {
            return false;
        }
        return this.base.test(itemStack) && itemStack.m_41773_() >= this.minDamage;
    }

    public boolean m_43947_() {
        return this.base.m_43947_();
    }

    public boolean isSimple() {
        return false;
    }

    protected void invalidate() {
        this.matchingStacks = null;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement m_43942_() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", NAME.toString());
        jsonObject.add("base", this.base.m_43942_());
        jsonObject.addProperty("min_damage", (Number)this.minDamage);
        return jsonObject;
    }

    public static class Serializer
    implements IIngredientSerializer<DamagedItemIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public DamagedItemIngredient parse(FriendlyByteBuf buffer) {
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int minDamage = buffer.m_130242_();
            return new DamagedItemIngredient(base, minDamage);
        }

        public DamagedItemIngredient parse(JsonObject json) {
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            int minDamage = GsonHelper.m_13927_((JsonObject)json, (String)"min_damage");
            return new DamagedItemIngredient(base, minDamage);
        }

        public void write(FriendlyByteBuf buffer, DamagedItemIngredient ingredient) {
            ingredient.base.m_43923_(buffer);
            buffer.m_130130_(ingredient.minDamage);
        }
    }
}

