/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.registries;

import com.radar.radioactive.common.blocks.BioScannerBlock;
import com.radar.radioactive.common.blocks.DecontaminatorBlock;
import com.radar.radioactive.common.blocks.GeigerCounterBlock;
import com.radar.radioactive.common.blocks.RadiationAbsorberBlock;
import com.radar.radioactive.common.items.ItemCustomFEBlock;
import com.radar.radioactive.common.registries.RadItems;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RadBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"radioactive");
    public static final RegistryObject<Block> DECONTAMINATOR = RadBlocks.registerBlock("decontaminator", () -> new DecontaminatorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60913_(2.0f, 1200.0f).m_60999_().m_60953_(state -> (Boolean)state.m_61143_((Property)DecontaminatorBlock.LIT) != false ? 5 : 0)), new Item.Properties().m_41487_(64).m_41486_(), "tooltip.radioactive.decontaminator");
    public static final RegistryObject<Block> RADIATION_ABSORBER_TIER_1 = RadBlocks.registerBlock("radiation_absorber_tier_1", () -> new RadiationAbsorberBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60913_(2.0f, 1200.0f).m_60999_().m_60953_(state -> (Boolean)state.m_61143_((Property)RadiationAbsorberBlock.LIT) != false ? 5 : 0), false, 1), new Item.Properties().m_41487_(64), "tooltip.radioactive.radiation_absorber_tier_1");
    public static final RegistryObject<Block> RADIATION_ABSORBER_TIER_2 = RadBlocks.registerBlock("radiation_absorber_tier_2", () -> new RadiationAbsorberBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60913_(2.0f, 1200.0f).m_60999_().m_60953_(state -> (Boolean)state.m_61143_((Property)RadiationAbsorberBlock.LIT) != false ? 5 : 0), false, 2), new Item.Properties().m_41487_(64).m_41486_().m_41497_(Rarity.UNCOMMON), "tooltip.radioactive.radiation_absorber_tier_2");
    public static final RegistryObject<Block> RADIATION_ABSORBER_TIER_CREATIVE = RadBlocks.registerBlock("radiation_absorber_creative", () -> new RadiationAbsorberBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_155954_(-1.0f).m_155956_(Float.MAX_VALUE).m_60999_().m_60953_(state -> (Boolean)state.m_61143_((Property)RadiationAbsorberBlock.LIT) != false ? 5 : 0), true, 2), new Item.Properties().m_41487_(1).m_41486_().m_41497_(Rarity.EPIC), "tooltip.radioactive.radiation_absorber_creative");
    public static final RegistryObject<Block> RADIATION_DETECTOR_BLOCK = RadBlocks.registerBlock("radiation_detector", () -> new GeigerCounterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)), new Item.Properties().m_41487_(64), "tooltip.radioactive.radiation_detector");
    public static final RegistryObject<Block> RADIATION_BIOSCANNER_BLOCK = RadBlocks.registerBlock("radiation_bioscanner", () -> new BioScannerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)), new Item.Properties().m_41487_(64), "tooltip.radioactive.radiation_bioscanner");
    public static final RegistryObject<Block> RADIOACTIVE_TEST_BLOCK = RadBlocks.registerBlock("radioactive_test_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(1.0f, 10.0f).m_60999_()), new Item.Properties().m_41487_(64).m_41486_(), "tooltip.radioactive.radioactive_test_block");

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, Item.Properties properties, String tooltipKey) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        RadBlocks.registerBlockItem(name, toReturn, properties, tooltipKey);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block, Item.Properties properties, String tooltipKey) {
        RadItems.ITEMS.register(name, () -> new ItemCustomFEBlock((Block)block.get(), properties, tooltipKey));
    }

    public static void register(IEventBus modEventBus) {
        BLOCKS.register(modEventBus);
    }
}

