/*
 * Decompiled with CFR 0.152.
 */
package com.radar.radioactive.common.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public final class RadFormat {
    private static final ThreadLocal<NumberFormat> DF = ThreadLocal.withInitial(() -> {
        DecimalFormat f = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        f.applyPattern("0.##");
        f.setGroupingUsed(false);
        return f;
    });

    private RadFormat() {
    }

    public static String format(float value) {
        return DF.get().format(value);
    }

    public static String formatPercent(float fraction) {
        return DF.get().format(fraction * 100.0f);
    }
}

